/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.model.mql;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonBoolean;
import com.willfp.eco.libs.bson.BsonDateTime;
import com.willfp.eco.libs.bson.BsonDecimal128;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDouble;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonNull;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.bson.types.Decimal128;
import com.willfp.eco.libs.mongodb.annotations.Beta;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlArray;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlBoolean;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlDate;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlDocument;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlEntry;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlExpression;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlInteger;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlMap;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlNumber;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlString;
import com.willfp.eco.libs.mongodb.client.model.mql.MqlValue;
import java.time.Instant;
import java.util.ArrayList;

@Beta(value={Beta.Reason.CLIENT})
public final class MqlValues {
    private MqlValues() {
    }

    public static MqlBoolean of(boolean of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonBoolean(of)));
    }

    public static MqlArray<MqlBoolean> ofBooleanArray(boolean ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonBoolean> list = new ArrayList<BsonBoolean>();
        for (boolean b : array) {
            list.add(new BsonBoolean(b));
        }
        return new MqlExpression<MqlBoolean>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(list)));
    }

    public static MqlInteger of(int of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonInt32(of)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(int ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonInt32> list = new ArrayList<BsonInt32>();
        for (int i : array) {
            list.add(new BsonInt32(i));
        }
        return new MqlExpression<MqlInteger>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(list)));
    }

    public static MqlInteger of(long of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonInt64(of)));
    }

    public static MqlArray<MqlInteger> ofIntegerArray(long ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonInt64> list = new ArrayList<BsonInt64>();
        for (long i : array) {
            list.add(new BsonInt64(i));
        }
        return new MqlExpression<MqlInteger>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(list)));
    }

    public static MqlNumber of(double of) {
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDouble(of)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(double ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDouble> list = new ArrayList<BsonDouble>();
        for (double n : array) {
            list.add(new BsonDouble(n));
        }
        return new MqlExpression<MqlNumber>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(list)));
    }

    public static MqlNumber of(Decimal128 of) {
        Assertions.notNull("Decimal128", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDecimal128(of)));
    }

    public static MqlArray<MqlNumber> ofNumberArray(Decimal128 ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDecimal128> result2 = new ArrayList<BsonDecimal128>();
        for (Decimal128 e : array) {
            Assertions.notNull("elements of array", e);
            result2.add(new BsonDecimal128(e));
        }
        return new MqlExpression<MqlNumber>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(result2)));
    }

    public static MqlDate of(Instant of) {
        Assertions.notNull("Instant", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(new BsonDateTime(of.toEpochMilli())));
    }

    public static MqlArray<MqlDate> ofDateArray(Instant ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonDateTime> result2 = new ArrayList<BsonDateTime>();
        for (Instant e : array) {
            Assertions.notNull("elements of array", e);
            result2.add(new BsonDateTime(e.toEpochMilli()));
        }
        return new MqlExpression<MqlDate>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(result2)));
    }

    public static MqlString of(String of) {
        Assertions.notNull("String", of);
        return new MqlExpression(codecRegistry -> new MqlExpression.AstPlaceholder(MqlValues.wrapString(of)));
    }

    public static MqlArray<MqlString> ofStringArray(String ... array) {
        Assertions.notNull("array", array);
        ArrayList<BsonValue> result2 = new ArrayList<BsonValue>();
        for (String e : array) {
            Assertions.notNull("elements of array", e);
            result2.add(MqlValues.wrapString(e));
        }
        return new MqlExpression<MqlString>(cr -> new MqlExpression.AstPlaceholder(new BsonArray(result2)));
    }

    private static BsonValue wrapString(String s2) {
        BsonString bson = new BsonString(s2);
        if (s2.contains("$")) {
            return new BsonDocument("$literal", bson);
        }
        return bson;
    }

    public static MqlDocument current() {
        return (MqlDocument)new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    public static <R extends MqlValue> MqlMap<R> currentAsMap() {
        return (MqlMap)new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonString("$$CURRENT"))).assertImplementsAllExpressions();
    }

    @SafeVarargs
    public static <T extends MqlValue> MqlArray<T> ofArray(T ... array) {
        Assertions.notNull("array", array);
        return new MqlExpression(cr -> {
            ArrayList<BsonValue> list = new ArrayList<BsonValue>();
            for (MqlValue v : array) {
                Assertions.notNull("elements of array", v);
                list.add(((MqlExpression)v).toBsonValue((CodecRegistry)cr));
            }
            return new MqlExpression.AstPlaceholder(new BsonArray(list));
        });
    }

    public static <T extends MqlValue> MqlEntry<T> ofEntry(MqlString k, T v) {
        Assertions.notNull("k", k);
        Assertions.notNull("v", v);
        return new MqlExpression(cr -> {
            BsonDocument document2 = new BsonDocument();
            document2.put("k", MqlExpression.toBsonValue(cr, k));
            document2.put("v", MqlExpression.toBsonValue(cr, v));
            return new MqlExpression.AstPlaceholder(document2);
        });
    }

    public static <T extends MqlValue> MqlMap<T> ofMap() {
        return MqlValues.ofMap(new BsonDocument());
    }

    public static <T extends MqlValue> MqlMap<T> ofMap(Bson map2) {
        Assertions.notNull("map", map2);
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonDocument("$literal", map2.toBsonDocument(BsonDocument.class, (CodecRegistry)cr))));
    }

    public static MqlDocument of(Bson document2) {
        Assertions.notNull("document", document2);
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonDocument("$literal", document2.toBsonDocument(BsonDocument.class, (CodecRegistry)cr))));
    }

    public static MqlValue ofNull() {
        return new MqlExpression(cr -> new MqlExpression.AstPlaceholder(new BsonNull())).assertImplementsAllExpressions();
    }

    static MqlNumber numberToMqlNumber(Number number) {
        Assertions.notNull("number", number);
        if (number instanceof Integer) {
            return MqlValues.of((Integer)number);
        }
        if (number instanceof Long) {
            return MqlValues.of((Long)number);
        }
        if (number instanceof Double) {
            return MqlValues.of((Double)number);
        }
        if (number instanceof Decimal128) {
            return MqlValues.of((Decimal128)number);
        }
        throw new IllegalArgumentException("Number must be one of: Integer, Long, Double, Decimal128");
    }
}

