/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.model.search;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDouble;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.annotations.Beta;
import com.willfp.eco.libs.mongodb.annotations.Sealed;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.search.ConstantSearchScore;
import com.willfp.eco.libs.mongodb.client.model.search.FieldSearchPath;
import com.willfp.eco.libs.mongodb.client.model.search.FunctionSearchScore;
import com.willfp.eco.libs.mongodb.client.model.search.PathBoostSearchScore;
import com.willfp.eco.libs.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.willfp.eco.libs.mongodb.client.model.search.SearchScoreExpression;
import com.willfp.eco.libs.mongodb.client.model.search.ValueBoostSearchScore;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", path).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", score));
    }
}

