/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal;

import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Iterables {
    @SafeVarargs
    public static <T> Iterable<T> concat(@Nullable T first2, T ... more) {
        return more == null ? Collections.singleton(first2) : Iterables.concat(first2, Arrays.asList(more));
    }

    public static <T> Iterable<T> concat(final @Nullable T first2, final Iterable<? extends T> more) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new ConcatIterator<Object>(first2, more);
            }

            public String toString() {
                return '[' + Stream.concat(Stream.of(first2), StreamSupport.stream(more.spliterator(), false)).map(Objects::toString).collect(Collectors.joining(", ")) + ']';
            }
        };
    }

    private Iterables() {
        throw Assertions.fail();
    }

    private static class ConcatIterator<T>
    implements Iterator<T> {
        private static final Object NONE = new Object();
        @Nullable
        private T first;
        @Nullable
        private Iterator<? extends T> moreIterator;
        private final Iterable<? extends T> more;

        ConcatIterator(@Nullable T first2, Iterable<? extends T> more) {
            this.first = first2;
            this.more = more;
        }

        @Override
        public boolean hasNext() {
            return this.firstNotConsumed() || this.moreIterator().hasNext();
        }

        @Override
        @Nullable
        public T next() {
            return this.firstNotConsumed() ? this.consumeFirst() : this.moreIterator().next();
        }

        private boolean firstNotConsumed() {
            return this.first != NONE;
        }

        @Nullable
        private T consumeFirst() {
            T result2 = this.first;
            this.first = NONE;
            return result2;
        }

        private Iterator<? extends T> moreIterator() {
            if (this.moreIterator == null) {
                this.moreIterator = this.more.iterator();
            }
            return this.moreIterator;
        }
    }
}

