/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonBinaryWriter;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.BsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.io.BasicOutputBuffer;
import com.willfp.eco.libs.mongodb.MongoDriverInformation;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class ClientMetadataHelper {
    public static final BsonDocument CLIENT_METADATA_DOCUMENT = new BsonDocument();
    private static final String SEPARATOR = "|";
    private static final String APPLICATION_FIELD = "application";
    private static final String APPLICATION_NAME_FIELD = "name";
    private static final String DRIVER_FIELD = "driver";
    private static final String DRIVER_NAME_FIELD = "name";
    private static final String DRIVER_VERSION_FIELD = "version";
    private static final String PLATFORM_FIELD = "platform";
    private static final String OS_FIELD = "os";
    private static final String OS_TYPE_FIELD = "type";
    private static final String OS_NAME_FIELD = "name";
    private static final String OS_ARCHITECTURE_FIELD = "architecture";
    private static final String OS_VERSION_FIELD = "version";
    private static final int MAXIMUM_CLIENT_METADATA_ENCODED_SIZE = 512;

    private static String getOperatingSystemType(String operatingSystemName) {
        if (ClientMetadataHelper.nameMatches(operatingSystemName, "linux")) {
            return "Linux";
        }
        if (ClientMetadataHelper.nameMatches(operatingSystemName, "mac")) {
            return "Darwin";
        }
        if (ClientMetadataHelper.nameMatches(operatingSystemName, "windows")) {
            return "Windows";
        }
        if (ClientMetadataHelper.nameMatches(operatingSystemName, "hp-ux", "aix", "irix", "solaris", "sunos")) {
            return "Unix";
        }
        return "unknown";
    }

    private static boolean nameMatches(String name, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!name.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static BsonDocument createClientMetadataDocument(@Nullable String applicationName) {
        return ClientMetadataHelper.createClientMetadataDocument(applicationName, null);
    }

    @Nullable
    public static BsonDocument createClientMetadataDocument(@Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation) {
        return ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation, CLIENT_METADATA_DOCUMENT);
    }

    @Nullable
    static BsonDocument createClientMetadataDocument(@Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, BsonDocument templateDocument) {
        if (applicationName != null) {
            Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", applicationName.getBytes(StandardCharsets.UTF_8).length <= 128);
        }
        BsonDocument document2 = templateDocument.clone();
        if (applicationName != null) {
            document2.append(APPLICATION_FIELD, new BsonDocument("name", new BsonString(applicationName)));
        }
        if (mongoDriverInformation != null) {
            ClientMetadataHelper.addDriverInformation(mongoDriverInformation, document2);
        }
        if (ClientMetadataHelper.clientMetadataDocumentTooLarge(document2)) {
            BsonDocument operatingSystemDocument = document2.getDocument(OS_FIELD, null);
            if (operatingSystemDocument != null) {
                operatingSystemDocument.remove("version");
                operatingSystemDocument.remove(OS_ARCHITECTURE_FIELD);
                operatingSystemDocument.remove("name");
            }
            if (operatingSystemDocument == null || ClientMetadataHelper.clientMetadataDocumentTooLarge(document2)) {
                document2.remove(PLATFORM_FIELD);
                if (ClientMetadataHelper.clientMetadataDocumentTooLarge(document2)) {
                    document2 = new BsonDocument(DRIVER_FIELD, templateDocument.getDocument(DRIVER_FIELD));
                    document2.append(OS_FIELD, new BsonDocument(OS_TYPE_FIELD, new BsonString("unknown")));
                    if (ClientMetadataHelper.clientMetadataDocumentTooLarge(document2)) {
                        document2 = null;
                    }
                }
            }
        }
        return document2;
    }

    private static BsonDocument addDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation, BsonDocument document2) {
        MongoDriverInformation driverInformation = ClientMetadataHelper.getDriverInformation(mongoDriverInformation);
        BsonDocument driverMetadataDocument = new BsonDocument("name", ClientMetadataHelper.listToBsonString(driverInformation.getDriverNames())).append("version", ClientMetadataHelper.listToBsonString(driverInformation.getDriverVersions()));
        document2.append(DRIVER_FIELD, driverMetadataDocument);
        document2.append(PLATFORM_FIELD, ClientMetadataHelper.listToBsonString(driverInformation.getDriverPlatforms()));
        return document2;
    }

    static boolean clientMetadataDocumentTooLarge(BsonDocument document2) {
        BasicOutputBuffer buffer = new BasicOutputBuffer(512);
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter(buffer), document2, EncoderContext.builder().build());
        return buffer.getPosition() > 512;
    }

    static MongoDriverInformation getDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        MongoDriverInformation.Builder builder = mongoDriverInformation != null ? MongoDriverInformation.builder(mongoDriverInformation) : MongoDriverInformation.builder();
        return builder.driverName("mongo-java-driver").driverVersion("4.10.2").driverPlatform(String.format("Java/%s/%s", System.getProperty("java.vendor", "unknown-vendor"), System.getProperty("java.runtime.version", "unknown-version"))).build();
    }

    static BsonString listToBsonString(List<String> listOfStrings) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (String val : listOfStrings) {
            if (i > 0) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(val);
            ++i;
        }
        return new BsonString(stringBuilder.toString());
    }

    private ClientMetadataHelper() {
    }

    static {
        BsonDocument driverMetadataDocument = ClientMetadataHelper.addDriverInformation(null, new BsonDocument());
        CLIENT_METADATA_DOCUMENT.append(DRIVER_FIELD, driverMetadataDocument.get(DRIVER_FIELD));
        try {
            String operatingSystemName = System.getProperty("os.name", "unknown");
            CLIENT_METADATA_DOCUMENT.append(OS_FIELD, new BsonDocument().append(OS_TYPE_FIELD, new BsonString(ClientMetadataHelper.getOperatingSystemType(operatingSystemName))).append("name", new BsonString(operatingSystemName)).append(OS_ARCHITECTURE_FIELD, new BsonString(System.getProperty("os.arch", "unknown"))).append("version", new BsonString(System.getProperty("os.version", "unknown")))).append(PLATFORM_FIELD, driverMetadataDocument.get(PLATFORM_FIELD, new BsonString("")));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

