/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonBoolean;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.Collation;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadBinding;
import com.willfp.eco.libs.mongodb.internal.binding.ReadBinding;
import com.willfp.eco.libs.mongodb.internal.client.model.AggregationLevel;
import com.willfp.eco.libs.mongodb.internal.connection.QueryResult;
import com.willfp.eco.libs.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncQueryBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.BatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import com.willfp.eco.libs.mongodb.internal.operation.OperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.OperationReadConcernHelper;
import com.willfp.eco.libs.mongodb.internal.operation.QueryBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.ReadOperation;
import com.willfp.eco.libs.mongodb.internal.session.SessionContext;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

class AggregateOperationImpl<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String RESULT = "result";
    private static final String CURSOR = "cursor";
    private static final String FIRST_BATCH = "firstBatch";
    private static final List<String> FIELD_NAMES_WITH_RESULT = Arrays.asList("result", "firstBatch");
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private final AggregateTarget aggregateTarget;
    private final PipelineCreator pipelineCreator;
    private boolean retryReads;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private long maxAwaitTimeMS;
    private long maxTimeMS;
    private BsonDocument variables;

    AggregateOperationImpl(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregationLevel aggregationLevel) {
        this(namespace, pipeline, decoder, AggregateOperationImpl.defaultAggregateTarget(Assertions.notNull("aggregationLevel", aggregationLevel), Assertions.notNull("namespace", namespace).getCollectionName()), AggregateOperationImpl.defaultPipelineCreator(pipeline));
    }

    AggregateOperationImpl(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregateTarget aggregateTarget, PipelineCreator pipelineCreator) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.aggregateTarget = Assertions.notNull("aggregateTarget", aggregateTarget);
        this.pipelineCreator = Assertions.notNull("pipelineCreator", pipelineCreator);
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    Decoder<T> getDecoder() {
        return this.decoder;
    }

    Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    AggregateOperationImpl<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    Integer getBatchSize() {
        return this.batchSize;
    }

    AggregateOperationImpl<T> batchSize(@Nullable Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    AggregateOperationImpl<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime >= 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    AggregateOperationImpl<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    Collation getCollation() {
        return this.collation;
    }

    AggregateOperationImpl<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    BsonValue getComment() {
        return this.comment;
    }

    AggregateOperationImpl<T> comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    AggregateOperationImpl<T> let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    AggregateOperationImpl<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    BsonValue getHint() {
        return this.hint;
    }

    AggregateOperationImpl<T> hint(@Nullable BsonValue hint) {
        Assertions.isTrueArgument("BsonString or BsonDocument", hint == null || hint.isDocument() || hint.isString());
        this.hint = hint;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        SingleResultCallback<AsyncBatchCursor<T>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.asyncTransformer(), this.retryReads, errHandlingCallback);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> this.getCommand(sessionContext, connectionDescription.getMaxWireVersion());
    }

    BsonDocument getCommand(SessionContext sessionContext, int maxWireVersion) {
        BsonDocument commandDocument = new BsonDocument("aggregate", this.aggregateTarget.create());
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, maxWireVersion, commandDocument);
        commandDocument.put("pipeline", this.pipelineCreator.create());
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", this.maxTimeMS > Integer.MAX_VALUE ? new BsonInt64(this.maxTimeMS) : new BsonInt32((int)this.maxTimeMS));
        }
        BsonDocument cursor = new BsonDocument();
        if (this.batchSize != null) {
            cursor.put("batchSize", new BsonInt32(this.batchSize));
        }
        commandDocument.put(CURSOR, cursor);
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            commandDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            commandDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            commandDocument.put("let", this.variables);
        }
        return commandDocument;
    }

    private QueryResult<T> createQueryResult(BsonDocument result2, ConnectionDescription description2) {
        return OperationHelper.cursorDocumentToQueryResult(result2.getDocument(CURSOR), description2.getServerAddress());
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, AggregateResponseBatchCursor<T>> transformer() {
        return (result2, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result2, connection.getDescription());
            return new QueryBatchCursor<T>(queryResult, 0, this.batchSize != null ? this.batchSize : 0, this.maxAwaitTimeMS, this.decoder, this.comment, source, connection, (BsonDocument)result2);
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result2, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result2, connection.getDescription());
            return new AsyncQueryBatchCursor<T>(queryResult, 0, this.batchSize != null ? this.batchSize : 0, this.maxAwaitTimeMS, this.decoder, this.comment, source, connection, (BsonDocument)result2);
        };
    }

    private static AggregateTarget defaultAggregateTarget(AggregationLevel aggregationLevel, String collectionName) {
        return () -> {
            if (aggregationLevel == AggregationLevel.DATABASE) {
                return new BsonInt32(1);
            }
            return new BsonString(collectionName);
        };
    }

    private static PipelineCreator defaultPipelineCreator(List<BsonDocument> pipeline) {
        return () -> new BsonArray(pipeline);
    }

    static interface AggregateTarget {
        public BsonValue create();
    }

    static interface PipelineCreator {
        public BsonArray create();
    }
}

