/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.Collation;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.internal.async.AsyncBatchCursor;
import com.willfp.eco.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncReadBinding;
import com.willfp.eco.libs.mongodb.internal.binding.ReadBinding;
import com.willfp.eco.libs.mongodb.internal.connection.QueryResult;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncSingleBatchQueryCursor;
import com.willfp.eco.libs.mongodb.internal.operation.BatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.CommandResultDocumentCodec;
import com.willfp.eco.libs.mongodb.internal.operation.DocumentHelper;
import com.willfp.eco.libs.mongodb.internal.operation.OperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.OperationReadConcernHelper;
import com.willfp.eco.libs.mongodb.internal.operation.QueryBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.ReadOperation;
import com.willfp.eco.libs.mongodb.internal.session.SessionContext;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public class DistinctOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String VALUES = "values";
    private final MongoNamespace namespace;
    private final String fieldName;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private long maxTimeMS;
    private Collation collation;
    private BsonValue comment;

    public DistinctOperation(MongoNamespace namespace, String fieldName, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.fieldName = Assertions.notNull("fieldName", fieldName);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public DistinctOperation<T> filter(@Nullable BsonDocument filter2) {
        this.filter = filter2;
        return this;
    }

    public DistinctOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public DistinctOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public DistinctOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public DistinctOperation<T> comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), this.createCommandDecoder(), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), this.createCommandDecoder(), this.asyncTransformer(), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, VALUES);
    }

    private QueryResult<T> createQueryResult(BsonDocument result2, ConnectionDescription description2) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result2, VALUES), 0L, description2.getServerAddress());
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result2, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result2, connection.getDescription());
            return new QueryBatchCursor<T>(queryResult, 0, 0, this.decoder, this.comment, source);
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result2, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result2, connection.getDescription());
            return new AsyncSingleBatchQueryCursor<T>(queryResult);
        };
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> this.getCommand(sessionContext, connectionDescription);
    }

    private BsonDocument getCommand(SessionContext sessionContext, ConnectionDescription connectionDescription) {
        BsonDocument commandDocument = new BsonDocument("distinct", new BsonString(this.namespace.getCollectionName()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), commandDocument);
        commandDocument.put("key", new BsonString(this.fieldName));
        DocumentHelper.putIfNotNull(commandDocument, "query", this.filter);
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.maxTimeMS);
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        DocumentHelper.putIfNotNull(commandDocument, "comment", this.comment);
        return commandDocument;
    }
}

