/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.AsyncWriteBinding;
import com.willfp.eco.libs.mongodb.internal.binding.WriteBinding;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.willfp.eco.libs.mongodb.internal.operation.CommandOperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.OperationHelper;
import com.willfp.eco.libs.mongodb.internal.operation.WriteConcernHelper;
import com.willfp.eco.libs.mongodb.internal.operation.WriteOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;

public class DropDatabaseOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final WriteConcern writeConcern;

    public DropDatabaseOperation(String databaseName) {
        this(databaseName, null);
    }

    public DropDatabaseOperation(String databaseName, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> {
            CommandOperationHelper.executeCommand(binding, this.databaseName, this.getCommand(), connection, CommandOperationHelper.writeConcernErrorTransformer());
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t2) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t2 != null) {
                errHandlingCallback.onResult(null, t2);
            } else {
                CommandOperationHelper.executeCommandAsync(binding, this.databaseName, this.getCommand(), connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), OperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("dropDatabase", new BsonInt32(1));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

