/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.AutoEncryptionSettings;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.bulk.BulkWriteResult;
import com.willfp.eco.libs.mongodb.client.model.BulkWriteOptions;
import com.willfp.eco.libs.mongodb.client.model.Collation;
import com.willfp.eco.libs.mongodb.client.model.CountOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateIndexOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateViewOptions;
import com.willfp.eco.libs.mongodb.client.model.DeleteOptions;
import com.willfp.eco.libs.mongodb.client.model.DropCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.DropIndexOptions;
import com.willfp.eco.libs.mongodb.client.model.EstimatedDocumentCountOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndDeleteOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndReplaceOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndUpdateOptions;
import com.willfp.eco.libs.mongodb.client.model.IndexModel;
import com.willfp.eco.libs.mongodb.client.model.InsertManyOptions;
import com.willfp.eco.libs.mongodb.client.model.InsertOneOptions;
import com.willfp.eco.libs.mongodb.client.model.MapReduceAction;
import com.willfp.eco.libs.mongodb.client.model.RenameCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.ReplaceOptions;
import com.willfp.eco.libs.mongodb.client.model.UpdateOptions;
import com.willfp.eco.libs.mongodb.client.model.WriteModel;
import com.willfp.eco.libs.mongodb.client.model.changestream.FullDocument;
import com.willfp.eco.libs.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.willfp.eco.libs.mongodb.internal.client.model.AggregationLevel;
import com.willfp.eco.libs.mongodb.internal.client.model.FindOptions;
import com.willfp.eco.libs.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.willfp.eco.libs.mongodb.internal.operation.BatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.ExplainableReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.MapReduceBatchCursor;
import com.willfp.eco.libs.mongodb.internal.operation.MapReduceStatistics;
import com.willfp.eco.libs.mongodb.internal.operation.Operations;
import com.willfp.eco.libs.mongodb.internal.operation.ReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.WriteOperation;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.List;

public final class SyncOperations<TDocument> {
    private final Operations<TDocument> operations;

    public SyncOperations(Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads) {
        this(null, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads);
    }

    public SyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads) {
        this(namespace, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads);
    }

    public SyncOperations(@Nullable MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads) {
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads);
    }

    public ReadOperation<Long> countDocuments(Bson filter2, CountOptions options2) {
        return this.operations.countDocuments(filter2, options2);
    }

    public ReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options2) {
        return this.operations.estimatedDocumentCount(options2);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> findFirst(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.operations.findFirst(filter2, resultClass, options2);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> find(Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.operations.find(filter2, resultClass, options2);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter2, Class<TResult> resultClass, FindOptions options2) {
        return this.operations.find(findNamespace, filter2, resultClass, options2);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> distinct(String fieldName, Bson filter2, Class<TResult> resultClass, long maxTimeMS, Collation collation, BsonValue comment) {
        return this.operations.distinct(fieldName, filter2, resultClass, maxTimeMS, collation, comment);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, @Nullable Integer batchSize, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, maxTimeMS, maxAwaitTimeMS, batchSize, collation, hint, hintString, comment, variables, allowDiskUse, aggregationLevel);
    }

    public ReadOperation<Void> aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, maxTimeMS, allowDiskUse, bypassDocumentValidation, collation, hint, hintString, comment, variables, aggregationLevel);
    }

    public WriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort, boolean verbose, MapReduceAction action, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter2, limit, maxTimeMS, jsMode, scope2, sort, verbose, action, nonAtomic, sharded, bypassDocumentValidation, collation);
    }

    public <TResult> ReadOperation<MapReduceBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope2, Bson sort, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter2, limit, maxTimeMS, jsMode, scope2, sort, verbose, collation);
    }

    public WriteOperation<TDocument> findOneAndDelete(Bson filter2, FindOneAndDeleteOptions options2) {
        return this.operations.findOneAndDelete(filter2, options2);
    }

    public WriteOperation<TDocument> findOneAndReplace(Bson filter2, TDocument replacement, FindOneAndReplaceOptions options2) {
        return this.operations.findOneAndReplace(filter2, replacement, options2);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter2, Bson update2, FindOneAndUpdateOptions options2) {
        return this.operations.findOneAndUpdate(filter2, update2, options2);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter2, List<? extends Bson> update2, FindOneAndUpdateOptions options2) {
        return this.operations.findOneAndUpdate(filter2, update2, options2);
    }

    public WriteOperation<BulkWriteResult> insertOne(TDocument document2, InsertOneOptions options2) {
        return this.operations.insertOne(document2, options2);
    }

    public WriteOperation<BulkWriteResult> replaceOne(Bson filter2, TDocument replacement, ReplaceOptions options2) {
        return this.operations.replaceOne(filter2, replacement, options2);
    }

    public WriteOperation<BulkWriteResult> deleteOne(Bson filter2, DeleteOptions options2) {
        return this.operations.deleteOne(filter2, options2);
    }

    public WriteOperation<BulkWriteResult> deleteMany(Bson filter2, DeleteOptions options2) {
        return this.operations.deleteMany(filter2, options2);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter2, Bson update2, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter2, update2, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter2, List<? extends Bson> update2, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter2, update2, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter2, Bson update2, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter2, update2, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter2, List<? extends Bson> update2, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter2, update2, updateOptions);
    }

    public WriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options2) {
        return this.operations.insertMany(documents, options2);
    }

    public WriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options2) {
        return this.operations.bulkWrite(requests, options2);
    }

    public <TResult> ReadOperation<TResult> commandRead(Bson command2, Class<TResult> resultClass) {
        return this.operations.commandRead(command2, resultClass);
    }

    public WriteOperation<Void> dropDatabase() {
        return this.operations.dropDatabase();
    }

    public WriteOperation<Void> createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.createCollection(collectionName, createCollectionOptions, autoEncryptionSettings);
    }

    public WriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public WriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options2) {
        return this.operations.renameCollection(newCollectionNamespace, options2);
    }

    public WriteOperation<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        return this.operations.createView(viewName, viewOn, pipeline, createViewOptions);
    }

    public WriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options2) {
        return this.operations.createIndexes(indexes, options2);
    }

    public WriteOperation<Void> dropIndex(String indexName2, DropIndexOptions options2) {
        return this.operations.dropIndex(indexName2, options2);
    }

    public WriteOperation<Void> dropIndex(Bson keys2, DropIndexOptions options2) {
        return this.operations.dropIndex(keys2, options2);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter2, boolean collectionNamesOnly, @Nullable Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listCollections(databaseName, resultClass, filter2, collectionNamesOnly, batchSize, maxTimeMS, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter2, Boolean nameOnly, long maxTimeMS, Boolean authorizedDatabases, BsonValue comment) {
        return this.operations.listDatabases(resultClass, filter2, nameOnly, maxTimeMS, authorizedDatabases, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listIndexes(Class<TResult> resultClass, @Nullable Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listIndexes(resultClass, batchSize, maxTimeMS, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> pipeline, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, @Nullable Integer batchSize, Collation collation, BsonValue comment, long maxAwaitTimeMS, BsonDocument resumeToken, BsonTimestamp startAtOperationTime, BsonDocument startAfter, boolean showExpandedEvents) {
        return this.operations.changeStream(fullDocument, fullDocumentBeforeChange, pipeline, decoder, changeStreamLevel, batchSize, collation, comment, maxAwaitTimeMS, resumeToken, startAtOperationTime, startAfter, showExpandedEvents);
    }
}

