/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistries;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.AutoEncryptionSettings;
import com.willfp.eco.libs.mongodb.ClientSessionOptions;
import com.willfp.eco.libs.mongodb.MongoClientSettings;
import com.willfp.eco.libs.mongodb.MongoDriverInformation;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterDescription;
import com.willfp.eco.libs.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.willfp.eco.libs.mongodb.internal.connection.ClientMetadataHelper;
import com.willfp.eco.libs.mongodb.internal.connection.Cluster;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Logger;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.willfp.eco.libs.mongodb.internal.session.ServerSessionPool;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClient;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoDatabase;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.ClientSessionHelper;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.ListDatabasesPublisherImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoDatabaseImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.OperationExecutorImpl;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt.Crypts;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final Cluster cluster;
    private final MongoClientSettings settings;
    private final OperationExecutor executor;
    private final Closeable externalResourceCloser;
    private final ServerSessionPool serverSessionPool;
    private final ClientSessionHelper clientSessionHelper;
    private final MongoOperationPublisher<Document> mongoOperationPublisher;
    private final Crypt crypt;
    private final AtomicBoolean closed;

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable Closeable externalResourceCloser) {
        this(settings, mongoDriverInformation, cluster, null, externalResourceCloser);
    }

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable OperationExecutor executor) {
        this(settings, mongoDriverInformation, cluster, executor, null);
    }

    private MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable OperationExecutor executor, @Nullable Closeable externalResourceCloser) {
        this.settings = Assertions.notNull("settings", settings);
        this.cluster = Assertions.notNull("cluster", cluster);
        this.serverSessionPool = new ServerSessionPool(cluster, settings.getServerApi());
        this.clientSessionHelper = new ClientSessionHelper(this, this.serverSessionPool);
        AutoEncryptionSettings autoEncryptSettings = settings.getAutoEncryptionSettings();
        this.crypt = autoEncryptSettings != null ? Crypts.createCrypt(this, autoEncryptSettings) : null;
        this.executor = executor == null ? new OperationExecutorImpl(this, this.clientSessionHelper) : executor;
        this.externalResourceCloser = externalResourceCloser;
        this.mongoOperationPublisher = new MongoOperationPublisher<Document>(Document.class, CodecRegistries.withUuidRepresentation(settings.getCodecRegistry(), settings.getUuidRepresentation()), settings.getReadPreference(), settings.getReadConcern(), settings.getWriteConcern(), settings.getRetryWrites(), settings.getRetryReads(), settings.getUuidRepresentation(), settings.getAutoEncryptionSettings(), this.executor);
        this.closed = new AtomicBoolean();
        BsonDocument clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(settings.getApplicationName(), mongoDriverInformation);
        if (clientMetadataDocument == null) {
            LOGGER.info(String.format("MongoClient created with settings %s", settings));
        } else {
            LOGGER.info(String.format("MongoClient with metadata %s created with settings %s", clientMetadataDocument.toJson(), settings));
        }
    }

    Cluster getCluster() {
        return this.cluster;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    MongoOperationPublisher<Document> getMongoOperationPublisher() {
        return this.mongoOperationPublisher;
    }

    @Nullable
    Crypt getCrypt() {
        return this.crypt;
    }

    public MongoClientSettings getSettings() {
        return this.settings;
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(this.mongoOperationPublisher.withDatabase(name));
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.crypt != null) {
                this.crypt.close();
            }
            this.serverSessionPool.close();
            this.cluster.close();
            if (this.externalResourceCloser != null) {
                try {
                    this.externalResourceCloser.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Exception closing resource", e);
                }
            }
        }
    }

    @Override
    public Publisher<String> listDatabaseNames() {
        return Flux.from(this.listDatabases().nameOnly(true)).map(d -> d.getString("name"));
    }

    @Override
    public Publisher<String> listDatabaseNames(ClientSession clientSession) {
        return Flux.from(this.listDatabases(clientSession).nameOnly(true)).map(d -> d.getString("name"));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesPublisher<T> listDatabases(Class<T> clazz) {
        return new ListDatabasesPublisherImpl<T>(null, this.mongoOperationPublisher.withDocumentClass(clazz));
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, (Class<T>)Document.class);
    }

    public <T> ListDatabasesPublisher<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesPublisherImpl<T>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher.withDocumentClass(clazz));
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    public <T> ChangeStreamPublisher<T> watch(Class<T> resultClass) {
        return this.watch((List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>(null, this.mongoOperationPublisher.withDatabase("admin"), resultClass, pipeline, ChangeStreamLevel.CLIENT);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, Class<T> resultClass) {
        return this.watch(clientSession, (List<? extends Bson>)Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, (Class<T>)Document.class);
    }

    public <T> ChangeStreamPublisher<T> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<T> resultClass) {
        return new ChangeStreamPublisherImpl<T>(Assertions.notNull("clientSession", clientSession), this.mongoOperationPublisher.withDatabase("admin"), resultClass, pipeline, ChangeStreamLevel.CLIENT);
    }

    @Override
    public Publisher<ClientSession> startSession() {
        return this.startSession(ClientSessionOptions.builder().build());
    }

    @Override
    public Publisher<ClientSession> startSession(ClientSessionOptions options2) {
        Assertions.notNull("options", options2);
        return Mono.fromCallable(() -> this.clientSessionHelper.createClientSession(options2, this.executor));
    }

    @Override
    public ClusterDescription getClusterDescription() {
        return this.getCluster().getCurrentDescription();
    }
}

