/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.UuidRepresentation;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistries;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.AutoEncryptionSettings;
import com.willfp.eco.libs.mongodb.MongoBulkWriteException;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.MongoNamespace;
import com.willfp.eco.libs.mongodb.MongoServerException;
import com.willfp.eco.libs.mongodb.MongoWriteConcernException;
import com.willfp.eco.libs.mongodb.MongoWriteException;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.WriteConcernResult;
import com.willfp.eco.libs.mongodb.WriteError;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.bulk.BulkWriteResult;
import com.willfp.eco.libs.mongodb.bulk.WriteConcernError;
import com.willfp.eco.libs.mongodb.client.model.BulkWriteOptions;
import com.willfp.eco.libs.mongodb.client.model.CountOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateIndexOptions;
import com.willfp.eco.libs.mongodb.client.model.CreateViewOptions;
import com.willfp.eco.libs.mongodb.client.model.DeleteOptions;
import com.willfp.eco.libs.mongodb.client.model.DropCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.DropIndexOptions;
import com.willfp.eco.libs.mongodb.client.model.EstimatedDocumentCountOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndDeleteOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndReplaceOptions;
import com.willfp.eco.libs.mongodb.client.model.FindOneAndUpdateOptions;
import com.willfp.eco.libs.mongodb.client.model.IndexModel;
import com.willfp.eco.libs.mongodb.client.model.IndexOptions;
import com.willfp.eco.libs.mongodb.client.model.InsertManyOptions;
import com.willfp.eco.libs.mongodb.client.model.InsertOneOptions;
import com.willfp.eco.libs.mongodb.client.model.RenameCollectionOptions;
import com.willfp.eco.libs.mongodb.client.model.ReplaceOptions;
import com.willfp.eco.libs.mongodb.client.model.UpdateOptions;
import com.willfp.eco.libs.mongodb.client.model.WriteModel;
import com.willfp.eco.libs.mongodb.client.result.DeleteResult;
import com.willfp.eco.libs.mongodb.client.result.InsertManyResult;
import com.willfp.eco.libs.mongodb.client.result.InsertOneResult;
import com.willfp.eco.libs.mongodb.client.result.UpdateResult;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.bulk.WriteRequest;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncOperations;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncReadOperation;
import com.willfp.eco.libs.mongodb.internal.operation.AsyncWriteOperation;
import com.willfp.eco.libs.mongodb.internal.operation.IndexHelper;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.ClientSession;
import com.willfp.eco.libs.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.willfp.eco.libs.reactivestreams.Publisher;
import com.willfp.eco.libs.reactor.core.publisher.Flux;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import com.willfp.eco.libs.reactor.core.publisher.MonoSink;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MongoOperationPublisher<T> {
    private final AsyncOperations<T> operations;
    private final UuidRepresentation uuidRepresentation;
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final OperationExecutor executor;
    private static final Function<BulkWriteResult, InsertOneResult> INSERT_ONE_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            BsonValue insertedId = result2.getInserts().isEmpty() ? null : result2.getInserts().get(0).getId();
            return InsertOneResult.acknowledged(insertedId);
        }
        return InsertOneResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, InsertManyResult> INSERT_MANY_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            return InsertManyResult.acknowledged(result2.getInserts().stream().collect(HashMap::new, (m4, v) -> m4.put(v.getIndex(), v.getId()), HashMap::putAll));
        }
        return InsertManyResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, DeleteResult> DELETE_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            return DeleteResult.acknowledged(result2.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, UpdateResult> UPDATE_RESULT_MAPPER = result2 -> {
        if (result2.wasAcknowledged()) {
            BsonValue upsertedId = result2.getUpserts().isEmpty() ? null : result2.getUpserts().get(0).getId();
            return UpdateResult.acknowledged(result2.getMatchedCount(), Long.valueOf(result2.getModifiedCount()), upsertedId);
        }
        return UpdateResult.unacknowledged();
    };

    MongoOperationPublisher(Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, OperationExecutor executor) {
        this(new MongoNamespace("_ignored", "_ignored"), documentClass, codecRegistry, readPreference, readConcern, writeConcern, retryWrites, retryReads, uuidRepresentation, autoEncryptionSettings, executor);
    }

    MongoOperationPublisher(MongoNamespace namespace, Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, OperationExecutor executor) {
        this.operations = new AsyncOperations<T>(namespace, Assertions.notNull("documentClass", documentClass), Assertions.notNull("readPreference", readPreference), Assertions.notNull("codecRegistry", codecRegistry), Assertions.notNull("readConcern", readConcern), Assertions.notNull("writeConcern", writeConcern), retryWrites, retryReads);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.executor = Assertions.notNull("executor", executor);
    }

    MongoNamespace getNamespace() {
        return this.operations.getNamespace();
    }

    ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public boolean getRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean getRetryReads() {
        return this.operations.isRetryReads();
    }

    Class<T> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public AsyncOperations<T> getOperations() {
        return this.operations;
    }

    MongoOperationPublisher<T> withDatabase(String name) {
        return this.withDatabaseAndDocumentClass(name, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDatabaseAndDocumentClass(String name, Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(new MongoNamespace(Assertions.notNull("name", name), "ignored"), Assertions.notNull("documentClass", documentClass));
    }

    MongoOperationPublisher<T> withNamespace(MongoNamespace namespace) {
        return this.withNamespaceAndDocumentClass(namespace, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDocumentClass(Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(this.getNamespace(), documentClass);
    }

    <D> MongoOperationPublisher<D> withNamespaceAndDocumentClass(MongoNamespace namespace, Class<D> documentClass) {
        if (this.getNamespace().equals(namespace) && this.getDocumentClass().equals(documentClass)) {
            return this;
        }
        return new MongoOperationPublisher<D>(Assertions.notNull("namespace", namespace), Assertions.notNull("documentClass", documentClass), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), CodecRegistries.withUuidRepresentation(Assertions.notNull("codecRegistry", codecRegistry), this.uuidRepresentation), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withReadPreference(ReadPreference readPreference) {
        if (this.getReadPreference().equals(readPreference)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), Assertions.notNull("readPreference", readPreference), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withWriteConcern(WriteConcern writeConcern) {
        if (this.getWriteConcern().equals(writeConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), Assertions.notNull("writeConcern", writeConcern), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    MongoOperationPublisher<T> withReadConcern(ReadConcern readConcern) {
        if (this.getReadConcern().equals(readConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), Assertions.notNull("readConcern", readConcern), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.executor);
    }

    Publisher<Void> dropDatabase(@Nullable ClientSession clientSession) {
        return this.createWriteOperationMono(this.operations::dropDatabase, clientSession);
    }

    Publisher<Void> createCollection(@Nullable ClientSession clientSession, String collectionName, CreateCollectionOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.createCollection(collectionName, options2, this.autoEncryptionSettings), clientSession);
    }

    Publisher<Void> createView(@Nullable ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.createView(viewName, viewOn, pipeline, options2), clientSession);
    }

    public <R> Publisher<R> runCommand(@Nullable ClientSession clientSession, Bson command2, ReadPreference readPreference, Class<R> clazz) {
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            return Mono.error(new MongoClientException("Read preference in a transaction must be primary"));
        }
        return this.createReadOperationMono(() -> this.operations.commandRead(command2, clazz), clientSession, Assertions.notNull("readPreference", readPreference));
    }

    Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options2) {
        return this.createReadOperationMono(() -> this.operations.estimatedDocumentCount(Assertions.notNull("options", options2)), null);
    }

    Publisher<Long> countDocuments(@Nullable ClientSession clientSession, Bson filter2, CountOptions options2) {
        return this.createReadOperationMono(() -> this.operations.countDocuments(Assertions.notNull("filter", filter2), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<BulkWriteResult> bulkWrite(@Nullable ClientSession clientSession, List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.bulkWrite(Assertions.notNull("requests", requests), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<InsertOneResult> insertOne(@Nullable ClientSession clientSession, T document2, InsertOneOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.insertOne(Assertions.notNull("document", document2), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.INSERT).map(INSERT_ONE_RESULT_MAPPER);
    }

    Publisher<InsertManyResult> insertMany(@Nullable ClientSession clientSession, List<? extends T> documents, InsertManyOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.insertMany(Assertions.notNull("documents", documents), Assertions.notNull("options", options2)), clientSession).map(INSERT_MANY_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteOne(@Nullable ClientSession clientSession, Bson filter2, DeleteOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteOne(Assertions.notNull("filter", filter2), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteMany(@Nullable ClientSession clientSession, Bson filter2, DeleteOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteMany(Assertions.notNull("filter", filter2), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> replaceOne(@Nullable ClientSession clientSession, Bson filter2, T replacement, ReplaceOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.replaceOne(Assertions.notNull("filter", filter2), Assertions.notNull("replacement", replacement), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.REPLACE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter2, Bson update2, UpdateOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne(Assertions.notNull("filter", filter2), Assertions.notNull("update", update2), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter2, List<? extends Bson> update2, UpdateOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne(Assertions.notNull("filter", filter2), Assertions.notNull("update", update2), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter2, Bson update2, UpdateOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany(Assertions.notNull("filter", filter2), Assertions.notNull("update", update2), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter2, List<? extends Bson> update2, UpdateOptions options2) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany(Assertions.notNull("filter", filter2), Assertions.notNull("update", update2), Assertions.notNull("options", options2)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<T> findOneAndDelete(@Nullable ClientSession clientSession, Bson filter2, FindOneAndDeleteOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndDelete(Assertions.notNull("filter", filter2), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<T> findOneAndReplace(@Nullable ClientSession clientSession, Bson filter2, T replacement, FindOneAndReplaceOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndReplace(Assertions.notNull("filter", filter2), Assertions.notNull("replacement", replacement), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter2, Bson update2, FindOneAndUpdateOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndUpdate(Assertions.notNull("filter", filter2), Assertions.notNull("update", update2), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter2, List<? extends Bson> update2, FindOneAndUpdateOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.findOneAndUpdate(Assertions.notNull("filter", filter2), Assertions.notNull("update", update2), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<Void> dropCollection(@Nullable ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        return this.createWriteOperationMono(() -> this.operations.dropCollection(dropCollectionOptions, this.autoEncryptionSettings), clientSession);
    }

    Publisher<String> createIndex(@Nullable ClientSession clientSession, Bson key, IndexOptions options2) {
        return this.createIndexes(clientSession, Collections.singletonList(new IndexModel(Assertions.notNull("key", key), options2)), new CreateIndexOptions());
    }

    Publisher<String> createIndexes(@Nullable ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.createIndexes(Assertions.notNull("indexes", indexes), Assertions.notNull("options", options2)), clientSession).thenMany(Flux.fromIterable(IndexHelper.getIndexNames(indexes, this.getCodecRegistry())));
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, String indexName2, DropIndexOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.dropIndex(Assertions.notNull("indexName", indexName2), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, Bson keys2, DropIndexOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.dropIndex(Assertions.notNull("keys", keys2), Assertions.notNull("options", options2)), clientSession);
    }

    Publisher<Void> dropIndexes(@Nullable ClientSession clientSession, DropIndexOptions options2) {
        return this.dropIndex(clientSession, "*", options2);
    }

    Publisher<Void> renameCollection(@Nullable ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options2) {
        return this.createWriteOperationMono(() -> this.operations.renameCollection(Assertions.notNull("newCollectionNamespace", newCollectionNamespace), Assertions.notNull("options", options2)), clientSession);
    }

    <R> Mono<R> createReadOperationMono(Supplier<AsyncReadOperation<R>> operation, @Nullable ClientSession clientSession) {
        return this.createReadOperationMono(operation, clientSession, this.getReadPreference());
    }

    <R> Mono<R> createReadOperationMono(Supplier<AsyncReadOperation<R>> operation, @Nullable ClientSession clientSession, ReadPreference readPreference) {
        AsyncReadOperation<R> readOperation = operation.get();
        return this.executor.execute(readOperation, readPreference, this.getReadConcern(), clientSession);
    }

    <R> Mono<R> createWriteOperationMono(Supplier<AsyncWriteOperation<R>> operation, @Nullable ClientSession clientSession) {
        AsyncWriteOperation<R> writeOperation = operation.get();
        return this.executor.execute(writeOperation, this.getReadConcern(), clientSession);
    }

    private Mono<BulkWriteResult> createSingleWriteRequestMono(Supplier<AsyncWriteOperation<BulkWriteResult>> operation, @Nullable ClientSession clientSession, WriteRequest.Type type2) {
        return this.createWriteOperationMono(operation, clientSession).onErrorMap(MongoBulkWriteException.class, e -> {
            MongoServerException exception;
            WriteConcernError writeConcernError = e.getWriteConcernError();
            if (e.getWriteErrors().isEmpty() && writeConcernError != null) {
                WriteConcernResult writeConcernResult = type2 == WriteRequest.Type.INSERT ? WriteConcernResult.acknowledged(e.getWriteResult().getInsertedCount(), false, null) : (type2 == WriteRequest.Type.DELETE ? WriteConcernResult.acknowledged(e.getWriteResult().getDeletedCount(), false, null) : WriteConcernResult.acknowledged(e.getWriteResult().getMatchedCount() + e.getWriteResult().getUpserts().size(), e.getWriteResult().getMatchedCount() > 0, e.getWriteResult().getUpserts().isEmpty() ? null : e.getWriteResult().getUpserts().get(0).getId()));
                exception = new MongoWriteConcernException(writeConcernError, writeConcernResult, e.getServerAddress());
            } else {
                exception = !e.getWriteErrors().isEmpty() ? new MongoWriteException(new WriteError(e.getWriteErrors().get(0)), e.getServerAddress()) : new MongoWriteException(new WriteError(-1, "Unknown write error", new BsonDocument()), e.getServerAddress());
            }
            for (String errorLabel : e.getErrorLabels()) {
                exception.addLabel(errorLabel);
            }
            return exception;
        });
    }

    public static <T> SingleResultCallback<T> sinkToCallback(MonoSink<T> sink) {
        return (result2, t2) -> {
            if (t2 != null) {
                sink.error(t2);
            } else if (result2 == null) {
                sink.success();
            } else {
                sink.success(result2);
            }
        };
    }
}

