/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt;

import com.willfp.eco.libs.bson.RawBsonDocument;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.AutoEncryptionSettings;
import com.willfp.eco.libs.mongodb.MongoClientException;
import com.willfp.eco.libs.mongodb.MongoException;
import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoCrypt;
import com.willfp.eco.libs.mongodb.internal.capi.MongoCryptHelper;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClient;
import com.willfp.eco.libs.mongodb.reactivestreams.client.MongoClients;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.io.Closeable;
import java.util.Map;

class CommandMarker
implements Closeable {
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = (Boolean)extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(extraOptions);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)extraOptions.get("mongocryptdURI")));
        }
    }

    Mono<RawBsonDocument> mark(String databaseName, RawBsonDocument command2) {
        if (this.client != null) {
            return this.runCommand(databaseName, command2).onErrorResume(Throwable.class, e -> {
                if (this.processBuilder == null) {
                    throw MongoException.fromThrowable(e);
                }
                return Mono.fromRunnable(() -> MongoCryptHelper.startProcess(this.processBuilder)).then(this.runCommand(databaseName, command2));
            }).onErrorMap(t2 -> new MongoClientException("Exception in encryption library: " + t2.getMessage(), (Throwable)t2));
        }
        return Mono.fromCallable(() -> command2);
    }

    private Mono<RawBsonDocument> runCommand(String databaseName, RawBsonDocument command2) {
        Assertions.assertNotNull(this.client);
        return Mono.from(this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)command2, RawBsonDocument.class));
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

