/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.reactivestreams.client.internal.crypt;

import com.willfp.eco.libs.bson.ByteBuf;
import com.willfp.eco.libs.bson.ByteBufNIO;
import com.willfp.eco.libs.mongodb.MongoSocketException;
import com.willfp.eco.libs.mongodb.ServerAddress;
import com.willfp.eco.libs.mongodb.connection.AsyncCompletionHandler;
import com.willfp.eco.libs.mongodb.connection.SocketSettings;
import com.willfp.eco.libs.mongodb.connection.SslSettings;
import com.willfp.eco.libs.mongodb.connection.Stream;
import com.willfp.eco.libs.mongodb.connection.StreamFactory;
import com.willfp.eco.libs.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoKeyDecryptor;
import com.willfp.eco.libs.mongodb.internal.connection.AsynchronousChannelStream;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Logger;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import com.willfp.eco.libs.reactor.core.publisher.MonoSink;
import java.io.Closeable;
import java.nio.channels.CompletionHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

class KeyManagementService
implements Closeable {
    private static final Logger LOGGER = Loggers.getLogger("client");
    private final Map<String, SSLContext> kmsProviderSslContextMap;
    private final int timeoutMillis;
    private final TlsChannelStreamFactoryFactory tlsChannelStreamFactoryFactory;

    KeyManagementService(Map<String, SSLContext> kmsProviderSslContextMap, int timeoutMillis) {
        this.kmsProviderSslContextMap = kmsProviderSslContextMap;
        this.tlsChannelStreamFactoryFactory = new TlsChannelStreamFactoryFactory();
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public void close() {
        this.tlsChannelStreamFactoryFactory.close();
    }

    Mono<Void> decryptKey(final MongoKeyDecryptor keyDecryptor) {
        SocketSettings socketSettings = SocketSettings.builder().connectTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS).build();
        StreamFactory streamFactory = this.tlsChannelStreamFactoryFactory.create(socketSettings, SslSettings.builder().enabled(true).context(this.kmsProviderSslContextMap.get(keyDecryptor.getKmsProvider())).build());
        ServerAddress serverAddress = new ServerAddress(keyDecryptor.getHostName());
        LOGGER.info("Connecting to KMS server at " + serverAddress);
        return Mono.create(sink -> {
            final Stream stream = streamFactory.create(serverAddress);
            stream.openAsync(new AsyncCompletionHandler<Void>(){

                @Override
                public void completed(@Nullable Void ignored) {
                    KeyManagementService.this.streamWrite(stream, keyDecryptor, sink);
                }

                @Override
                public void failed(Throwable t2) {
                    stream.close();
                    sink.error(t2);
                }
            });
        }).onErrorMap(this::unWrapException);
    }

    private void streamWrite(final Stream stream, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink) {
        List<ByteBuf> byteBufs = Collections.singletonList(new ByteBufNIO(keyDecryptor.getMessage()));
        stream.writeAsync(byteBufs, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(@Nullable Void aVoid) {
                KeyManagementService.this.streamRead(stream, keyDecryptor, sink);
            }

            @Override
            public void failed(Throwable t2) {
                stream.close();
                sink.error(t2);
            }
        });
    }

    private void streamRead(final Stream stream, final MongoKeyDecryptor keyDecryptor, final MonoSink<Void> sink) {
        int bytesNeeded = keyDecryptor.bytesNeeded();
        if (bytesNeeded > 0) {
            AsynchronousChannelStream asyncStream = (AsynchronousChannelStream)stream;
            final ByteBuf buffer = asyncStream.getBuffer(bytesNeeded);
            asyncStream.getChannel().read(buffer.asNIO(), asyncStream.getSettings().getReadTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, null, new CompletionHandler<Integer, Void>(){

                @Override
                public void completed(Integer integer, Void aVoid) {
                    buffer.flip();
                    try {
                        keyDecryptor.feed(buffer.asNIO());
                        buffer.release();
                        KeyManagementService.this.streamRead(stream, keyDecryptor, sink);
                    }
                    catch (Throwable t2) {
                        sink.error(t2);
                    }
                }

                @Override
                public void failed(Throwable t2, Void aVoid) {
                    buffer.release();
                    stream.close();
                    sink.error(t2);
                }
            });
        } else {
            stream.close();
            sink.success();
        }
    }

    private Throwable unWrapException(Throwable t2) {
        return t2 instanceof MongoSocketException ? t2.getCause() : t2;
    }
}

