/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.objenesis.strategy;

import com.willfp.eco.libs.objenesis.ObjenesisException;
import com.willfp.eco.libs.objenesis.instantiator.ObjectInstantiator;
import com.willfp.eco.libs.objenesis.strategy.InstantiatorStrategy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class SingleInstantiatorStrategy
implements InstantiatorStrategy {
    private final Constructor<?> constructor;

    public <T extends ObjectInstantiator<?>> SingleInstantiatorStrategy(Class<T> instantiator) {
        try {
            this.constructor = instantiator.getConstructor(Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new ObjenesisException(e);
        }
    }

    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type2) {
        try {
            return (ObjectInstantiator)this.constructor.newInstance(type2);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ObjenesisException(e);
        }
    }
}

