/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.reactor.core.publisher;

import com.willfp.eco.libs.reactor.core.CoreSubscriber;
import com.willfp.eco.libs.reactor.core.Fuseable;
import com.willfp.eco.libs.reactor.core.Scannable;
import com.willfp.eco.libs.reactor.core.publisher.FluxFilter;
import com.willfp.eco.libs.reactor.core.publisher.InternalMonoOperator;
import com.willfp.eco.libs.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.function.Predicate;

final class MonoFilter<T>
extends InternalMonoOperator<T, T> {
    final Predicate<? super T> predicate;

    MonoFilter(Mono<? extends T> source, Predicate<? super T> predicate2) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate2, "predicate");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new FluxFilter.FilterConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)actual, this.predicate);
        }
        return new FluxFilter.FilterSubscriber<T>(actual, this.predicate);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

