/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.tuples.Pair;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.bukkit.entity.Player;

public final class MenuUtils {
    @NotNull
    public static Pair<Integer, Integer> convertSlotToRowColumn(int slot) {
        return MenuUtils.convertSlotToRowColumn(slot, 9);
    }

    public static int rowColumnToSlot(int row2, int column) {
        return MenuUtils.rowColumnToSlot(row2, column, 9);
    }

    @NotNull
    public static Pair<Integer, Integer> convertSlotToRowColumn(int slot, int columns2) {
        int row2 = Math.floorDiv(slot, columns2);
        int column = slot - row2 * columns2;
        return new Pair<Integer, Integer>(row2 + 1, column + 1);
    }

    public static int rowColumnToSlot(int row2, int column, int columns2) {
        return column - 1 + (row2 - 1) * columns2;
    }

    @Nullable
    public static Menu getOpenMenu(@NotNull Player player) {
        return Eco.get().getOpenMenu(player);
    }

    private MenuUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

