/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.util;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public final class VectorUtils {
    private static final Map<Integer, Vector[]> CIRCLE_CACHE = new HashMap<Integer, Vector[]>();

    public static boolean isFinite(@NotNull Vector vector) {
        try {
            NumberConversions.checkFinite((double)vector.getX(), (String)"x not finite");
            NumberConversions.checkFinite((double)vector.getY(), (String)"y not finite");
            NumberConversions.checkFinite((double)vector.getZ(), (String)"z not finite");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public static Vector simplifyVector(@NotNull Vector vec) {
        double x = Math.abs(vec.getX());
        double y = Math.abs(vec.getY());
        double z = Math.abs(vec.getZ());
        double max = Math.max(x, Math.max(y, z));
        if (x > 1.0 || z > 1.0) {
            max = y;
        }
        if (max == x) {
            if (vec.getX() < 0.0) {
                return new Vector(-1, 0, 0);
            }
            return new Vector(1, 0, 0);
        }
        if (max == y) {
            if (vec.getY() < 0.0) {
                return new Vector(0, -1, 0);
            }
            return new Vector(0, 1, 0);
        }
        if (vec.getZ() < 0.0) {
            return new Vector(0, 0, -1);
        }
        return new Vector(0, 0, 1);
    }

    @NotNull
    public static Vector[] getCircle(int radius) {
        Vector[] cached = CIRCLE_CACHE.get(radius);
        if (cached != null) {
            return cached;
        }
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        double xoffset = -radius;
        for (double zoffset = (double)(-radius); zoffset <= (double)radius; zoffset += 1.0) {
            while (xoffset <= (double)radius) {
                if (Math.round(Math.sqrt(xoffset * xoffset + zoffset * zoffset)) > (long)radius) {
                    xoffset += 1.0;
                    continue;
                }
                vectors.add(new Vector(xoffset, 0.0, zoffset));
                xoffset += 1.0;
            }
            xoffset = -radius;
        }
        Vector[] result2 = vectors.toArray(new Vector[0]);
        CIRCLE_CACHE.put(radius, result2);
        return result2;
    }

    @NotNull
    public static Vector[] getSquare(int radius) {
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        int xoffset = -radius;
        for (int zoffset = -radius; zoffset <= radius; ++zoffset) {
            while (xoffset <= radius) {
                vectors.add(new Vector(xoffset, 0, zoffset));
                ++xoffset;
            }
            xoffset = -radius;
        }
        return vectors.toArray(new Vector[0]);
    }

    @NotNull
    public static Vector[] getCube(int radius) {
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        for (int y = -radius; y <= radius; ++y) {
            for (int z = -radius; z <= radius; ++z) {
                for (int x = -radius; x <= radius; ++x) {
                    vectors.add(new Vector(x, y, z));
                }
            }
        }
        return vectors.toArray(new Vector[0]);
    }

    public static boolean isSafeVelocity(@NotNull Vector vec) {
        double x = Math.abs(vec.getX());
        double y = Math.abs(vec.getY());
        double z = Math.abs(vec.getZ());
        return x < 4.0 && y < 4.0 && z < 4.0;
    }

    private VectorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

