/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Arrays;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;

public final class JvmMetadataVersion
extends BinaryVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isStrictSemantics;
    @JvmField
    @NotNull
    public static final JvmMetadataVersion INSTANCE;
    @JvmField
    @NotNull
    public static final JvmMetadataVersion INSTANCE_NEXT;
    @JvmField
    @NotNull
    public static final JvmMetadataVersion INVALID_VERSION;

    public JvmMetadataVersion(@NotNull int[] versionArray, boolean isStrictSemantics) {
        Intrinsics.checkNotNullParameter(versionArray, "versionArray");
        super(Arrays.copyOf(versionArray, versionArray.length));
        this.isStrictSemantics = isStrictSemantics;
    }

    public final boolean isStrictSemantics() {
        return this.isStrictSemantics;
    }

    public JvmMetadataVersion(int ... numbers) {
        Intrinsics.checkNotNullParameter(numbers, "numbers");
        this(numbers, false);
    }

    @NotNull
    public final JvmMetadataVersion lastSupportedVersionWithThisLanguageVersion(boolean isStrictSemantics) {
        JvmMetadataVersion forwardCompatibility = isStrictSemantics ? INSTANCE : INSTANCE_NEXT;
        return forwardCompatibility.newerThan(this) ? forwardCompatibility : this;
    }

    public final boolean isCompatible(@NotNull JvmMetadataVersion metadataVersionFromLanguageVersion) {
        Intrinsics.checkNotNullParameter(metadataVersionFromLanguageVersion, "metadataVersionFromLanguageVersion");
        if (this.getMajor() == 2 && this.getMinor() == 0 && INSTANCE.getMajor() == 1 && INSTANCE.getMinor() == 8) {
            return true;
        }
        JvmMetadataVersion limitVersion = metadataVersionFromLanguageVersion.lastSupportedVersionWithThisLanguageVersion(this.isStrictSemantics);
        return this.isCompatibleInternal(limitVersion);
    }

    private final boolean isCompatibleInternal(JvmMetadataVersion limitVersion) {
        if (this.getMajor() == 1 && this.getMinor() == 0) {
            return false;
        }
        if (this.getMajor() == 0) {
            return false;
        }
        return !this.newerThan(limitVersion);
    }

    @NotNull
    public final JvmMetadataVersion next() {
        JvmMetadataVersion jvmMetadataVersion;
        if (this.getMajor() == 1 && this.getMinor() == 9) {
            int[] nArray = new int[]{2, 0, 0};
            JvmMetadataVersion jvmMetadataVersion2 = new JvmMetadataVersion(nArray);
            jvmMetadataVersion = jvmMetadataVersion2;
        } else {
            int[] nArray = new int[]{this.getMajor(), this.getMinor() + 1, 0};
            JvmMetadataVersion jvmMetadataVersion3 = new JvmMetadataVersion(nArray);
            jvmMetadataVersion = jvmMetadataVersion3;
        }
        return jvmMetadataVersion;
    }

    private final boolean newerThan(JvmMetadataVersion other) {
        return this.getMajor() > other.getMajor() ? true : (this.getMajor() < other.getMajor() ? false : this.getMinor() > other.getMinor());
    }

    static {
        int[] nArray = new int[]{1, 8, 0};
        INSTANCE = new JvmMetadataVersion(nArray);
        INSTANCE_NEXT = INSTANCE.next();
        INVALID_VERSION = new JvmMetadataVersion(new int[0]);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

