/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.EntityIDFunctionProvider;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/EntityIDColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "idColumn", "Lorg/jetbrains/exposed/sql/Column;", "(Lorg/jetbrains/exposed/sql/Column;)V", "getIdColumn", "()Lorg/jetbrains/exposed/sql/Column;", "equals", "", "other", "", "hashCode", "", "nonNullValueToString", "", "value", "notNullValueToDB", "sqlType", "valueFromDB", "Lorg/jetbrains/exposed/dao/id/EntityID;", "exposed-core"})
public final class EntityIDColumnType<T extends Comparable<? super T>>
extends ColumnType {
    @NotNull
    private final Column<T> idColumn;

    public EntityIDColumnType(@NotNull Column<T> idColumn) {
        Intrinsics.checkNotNullParameter(idColumn, "idColumn");
        super(false, 1, null);
        this.idColumn = idColumn;
        if (!(this.idColumn.getTable() instanceof IdTable)) {
            boolean bl = false;
            String string = "EntityId supported only for IdTables";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Column<T> getIdColumn() {
        return this.idColumn;
    }

    @Override
    @NotNull
    public String sqlType() {
        return this.idColumn.getColumnType().sqlType();
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return this.idColumn.getColumnType().notNullValueToDB(value instanceof EntityID ? ((EntityID)value).getValue() : value);
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return this.idColumn.getColumnType().nonNullValueToString(value instanceof EntityID ? ((EntityID)value).getValue() : value);
    }

    @Override
    @NotNull
    public EntityID<T> valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return EntityIDFunctionProvider.INSTANCE.createEntityID(value instanceof EntityID ? ((EntityID)value).getValue() : (Comparable)this.idColumn.getColumnType().valueFromDB(value), (IdTable)this.idColumn.getTable());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.exposed.sql.EntityIDColumnType<*>");
        }
        EntityIDColumnType cfr_ignored_0 = (EntityIDColumnType)object2;
        return Intrinsics.areEqual(this.idColumn, ((EntityIDColumnType)other).idColumn);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.idColumn.hashCode();
    }
}

