/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.manifest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.AbstractUpdater;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.UpdateChannel;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.Version;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.VersionNumber;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.Locale;
import org.bukkit.plugin.Plugin;

public class ManifestUpdater
extends AbstractUpdater {
    private final JsonParser jsonParser = new JsonParser();
    private final String manifestUrl;
    private final UpdateChannel channel;

    public ManifestUpdater(Plugin plugin, Duration frequency, String manifestUrl, UpdateChannel channel) {
        super(plugin, frequency);
        this.manifestUrl = manifestUrl;
        this.channel = channel;
    }

    @Override
    protected Version fetchLatestVersion() {
        JsonElement json = this.readJsonFromURL(this.manifestUrl);
        if (json == null) {
            return null;
        }
        if (!json.isJsonArray()) {
            return null;
        }
        for (JsonElement versionElement : json.getAsJsonArray()) {
            Version version = this.parseVersion(versionElement.getAsJsonObject());
            if (!this.isCompatible(version, this.channel)) continue;
            return version;
        }
        return null;
    }

    private Version parseVersion(JsonObject info) {
        return Version.builder().versionNumber(VersionNumber.of(info.get("version").getAsString())).downloadUrl(info.has("downloadUrl") ? info.get("downloadUrl").getAsString() : null).changelogUrl(info.has("changelogUrl") ? info.get("changelogUrl").getAsString() : null).channel(info.has("channel") ? UpdateChannel.valueOf(info.get("channel").getAsString().toUpperCase(Locale.ROOT)) : UpdateChannel.STABLE).minMinecraftVersion(info.has("minMcVersion") ? VersionNumber.of(info.get("minMcVersion").getAsString()) : null).maxMinecraftVersion(info.has("maxMcVersion") ? VersionNumber.of(info.get("maxMcVersion").getAsString()) : null).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonElement readJsonFromURL(String downloadURL) {
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(downloadURL);
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            connection.addRequestProperty("User-Agent", this.getClass().getSimpleName() + "/v1 (by lenis0012)");
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            JsonElement jsonElement = this.jsonParser.parse(builder.toString());
            return jsonElement;
        }
        catch (IOException e) {
            this.verboseLog("Failed to read JSON from URL: " + downloadURL, e);
            JsonElement jsonElement = null;
            return jsonElement;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

