/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.manifest;

import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.UpdateChannel;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.Updater;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.UpdaterFactory;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.manifest.ManifestUpdater;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ManifestUpdaterFactory
implements UpdaterFactory {
    private Duration frequency = Duration.ofHours(3L);
    private UpdateChannel channel = UpdateChannel.STABLE;

    @Override
    public Updater getUpdater(Plugin plugin) {
        String manifestUrl;
        try (InputStreamReader reader = new InputStreamReader(plugin.getResource("plugin.yml"), StandardCharsets.UTF_8);){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            manifestUrl = config.getString("manifest-url");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load plugin.yml", e);
        }
        return new ManifestUpdater(plugin, this.frequency, manifestUrl, this.channel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCompatible(Plugin plugin) {
        try (InputStreamReader reader = new InputStreamReader(plugin.getResource("plugin.yml"), StandardCharsets.UTF_8);){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            String url = config.getString("manifest-url");
            if (url == null) {
                boolean bl = false;
                return bl;
            }
            new URL(url);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public UpdaterFactory withChannel(UpdateChannel channel) {
        this.channel = channel;
        return this;
    }

    @Override
    public UpdaterFactory withFrequency(Duration updateInterval) {
        this.frequency = updateInterval;
        return this;
    }

    @Override
    public Set<UpdaterFactory.Capability> capabilities() {
        return new HashSet<UpdaterFactory.Capability>(Arrays.asList(UpdaterFactory.Capability.VERSION_CHECK, UpdaterFactory.Capability.COMPATIBILITY_CHECK, UpdaterFactory.Capability.CHANNELS, UpdaterFactory.Capability.WEBLINK, UpdaterFactory.Capability.DOWNLOAD));
    }
}

