/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.session;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.session.AuthMode;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.storage.PlayerProfile;
import com.lenis0012.bukkit.loginsecurity.util.ProfileUtil;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class SessionManager {
    private final Map<UUID, PlayerSession> activeSessions = Maps.newConcurrentMap();
    private final LoadingCache<UUID, PlayerSession> preloadCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<UUID, PlayerSession>(){

        public PlayerSession load(UUID uuid) throws Exception {
            return SessionManager.this.newSession(uuid);
        }
    });

    public PlayerSession preloadSession(String playerName, UUID playerUUID) {
        UUID profileId = ProfileUtil.getUUID(playerName, playerUUID);
        return (PlayerSession)this.preloadCache.getUnchecked((Object)profileId);
    }

    public final PlayerSession getPlayerSession(Player player) {
        PlayerSession session;
        UUID userId = ProfileUtil.getUUID(player);
        if (this.activeSessions.containsKey(userId)) {
            session = this.activeSessions.get(userId);
        } else {
            session = (PlayerSession)this.preloadCache.getUnchecked((Object)userId);
            if (player.isOnline()) {
                this.activeSessions.put(userId, session);
                this.preloadCache.invalidate((Object)userId);
            }
        }
        return session;
    }

    public final PlayerSession getOfflineSession(UUID profileId) {
        return this.newSession(profileId);
    }

    public final PlayerSession getOfflineSession(String playerName) {
        try {
            PlayerProfile profile = LoginSecurity.getDatastore().getProfileRepository().findByLastNameBlocking(playerName);
            if (profile == null) {
                OfflinePlayer offline = Bukkit.getOfflinePlayer((String)playerName);
                if (offline == null || offline.getUniqueId() == null) {
                    return null;
                }
                return this.getOfflineSession(ProfileUtil.getUUID(playerName, offline.getUniqueId()));
            }
            return new PlayerSession(profile, AuthMode.UNAUTHENTICATED);
        }
        catch (SQLException e) {
            LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to load profile", e);
            return null;
        }
    }

    public void onPlayerLogout(Player player) {
        UUID userId = ProfileUtil.getUUID(player);
        this.activeSessions.remove(userId);
    }

    private final PlayerSession newSession(UUID playerId) {
        try {
            PlayerProfile profile = LoginSecurity.getDatastore().getProfileRepository().findByUniqueUserIdBlocking(playerId);
            AuthMode authMode = AuthMode.UNAUTHENTICATED;
            if (profile == null) {
                profile = this.createBlankProfile(playerId);
                authMode = LoginSecurity.getConfiguration().isPasswordRequired() ? AuthMode.UNREGISTERED : AuthMode.AUTHENTICATED;
            }
            return new PlayerSession(profile, authMode);
        }
        catch (SQLException e) {
            LoginSecurity.getInstance().getLogger().log(Level.SEVERE, "Failed to load profile", e);
            return null;
        }
    }

    protected final PlayerProfile createBlankProfile(UUID playerId) {
        PlayerProfile profile = new PlayerProfile();
        profile.setUniqueUserId(playerId.toString());
        profile.setUniqueIdMode(ProfileUtil.getUserIdMode());
        return profile;
    }
}

