/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.bukkit;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.util.CachedServerIcon;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.minimotd.lib.io.papermc.lib.PaperLib;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.minimotd.lib.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.lib.platform_bukkit.xyz.jpenilla.minimotd.common.config.MiniMOTDConfig;

public final class PaperPingListener
implements Listener {
    private final LegacyComponentSerializer unusualHexSerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private final MiniMOTD<CachedServerIcon> miniMOTD;

    PaperPingListener(@NonNull MiniMOTD<CachedServerIcon> miniMOTD) {
        this.miniMOTD = miniMOTD;
    }

    @EventHandler
    public void handlePing(@NonNull PaperServerListPingEvent event) {
        MiniMOTDConfig cfg = this.miniMOTD.configManager().mainConfig();
        PingResponse<CachedServerIcon> response = this.miniMOTD.createMOTD(cfg, event.getNumPlayers(), event.getMaxPlayers());
        response.playerCount().applyCount(arg_0 -> ((PaperServerListPingEvent)event).setNumPlayers(arg_0), arg_0 -> ((PaperServerListPingEvent)event).setMaxPlayers(arg_0));
        response.motd(motd -> {
            if (event.getClient().getProtocolVersion() < 735 || PaperLib.getMinecraftVersion() < 16) {
                event.setMotd(LegacyComponentSerializer.legacySection().serialize((Component)motd));
            } else {
                event.setMotd(this.unusualHexSerializer.serialize((Component)motd));
            }
        });
        response.icon(arg_0 -> ((PaperServerListPingEvent)event).setServerIcon(arg_0));
        if (response.disablePlayerListHover()) {
            event.getPlayerSample().clear();
        }
        if (response.hidePlayerCount()) {
            event.setHidePlayers(true);
        }
    }
}

