/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.lib.org.spongepowered.configurate;

import java.util.Map;
import java.util.stream.Collector;
import xyz.jpenilla.minimotd.lib.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.minimotd.lib.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.minimotd.lib.org.spongepowered.configurate.ConfigurationOptions;
import xyz.jpenilla.minimotd.lib.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.minimotd.lib.org.spongepowered.configurate.util.CheckedConsumer;

@FunctionalInterface
public interface ConfigurationNodeFactory<N extends ConfigurationNode> {
    default public ConfigurationOptions defaultOptions() {
        return ConfigurationOptions.defaults();
    }

    public N createNode(ConfigurationOptions var1);

    default public N createNode() {
        return this.createNode(this.defaultOptions());
    }

    default public <E extends Exception> N createNode(CheckedConsumer<N, E> action) throws E {
        N node = this.createNode();
        action.accept(node);
        return node;
    }

    default public <E extends Exception> N createNode(ConfigurationOptions options, CheckedConsumer<N, E> action) throws E {
        N node = this.createNode(options);
        action.accept(node);
        return node;
    }

    default public <V> Collector<Map.Entry<?, V>, N, N> toMapCollector(TypeToken<V> valueType) {
        return Collector.of(this::createNode, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    default public <V> Collector<Map.Entry<?, V>, N, N> toMapCollector(Class<V> valueType) {
        return Collector.of(this::createNode, (node, entry) -> {
            try {
                node.node(entry.getKey()).set(valueType, entry.getValue());
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, N, N> toListCollector(TypeToken<V> valueType) {
        return Collector.of(this::createNode, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    default public <V> Collector<V, N, N> toListCollector(Class<V> valueType) {
        return Collector.of(this::createNode, (node, value) -> {
            try {
                node.appendListNode().set(valueType, value);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException(e);
            }
        }, (a, b) -> {
            a.mergeFrom((ConfigurationNode)b);
            return a;
        }, new Collector.Characteristics[0]);
    }
}

