/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.database.Rollback;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.Util;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class EntityUtil {
    private EntityUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void spawnEntity(BlockState block, EntityType type, List<Object> list) {
        if (type == null) {
            return;
        }
        Scheduler.runTask(CoreProtect.getInstance(), () -> {
            try {
                int count;
                Location location = block.getLocation();
                location.setX(location.getX() + 0.5);
                location.setZ(location.getZ() + 0.5);
                Entity entity = block.getLocation().getWorld().spawnEntity(location, type);
                if (list.isEmpty()) {
                    return;
                }
                List age = (List)list.get(0);
                List tame = (List)list.get(1);
                List data = (List)list.get(2);
                if (list.size() >= 5) {
                    entity.setCustomNameVisible(((Boolean)list.get(3)).booleanValue());
                    entity.setCustomName((String)list.get(4));
                }
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                int wid = Util.getWorldId(block.getWorld().getName());
                String token = block.getX() + "." + block.getY() + "." + block.getZ() + "." + wid + "." + type.name();
                CacheHandler.entityCache.put(token, new Object[]{unixtimestamp, entity.getEntityId()});
                if (entity instanceof Ageable) {
                    count = 0;
                    Ageable ageable = (Ageable)entity;
                    for (Object value : age) {
                        if (count == 0) {
                            int set = (Integer)value;
                            ageable.setAge(set);
                        } else if (count == 1) {
                            boolean set = (Boolean)value;
                            ageable.setAgeLock(set);
                        } else if (count == 2) {
                            boolean set = (Boolean)value;
                            if (set) {
                                ageable.setAdult();
                            } else {
                                ageable.setBaby();
                            }
                        } else if (count == 3) {
                            boolean set = (Boolean)value;
                            ageable.setBreed(set);
                        } else if (count == 4 && value != null) {
                            double set = (Double)value;
                            ageable.setMaxHealth(set);
                        }
                        ++count;
                    }
                }
                if (entity instanceof Tameable) {
                    count = 0;
                    Tameable tameable = (Tameable)entity;
                    for (Object value : tame) {
                        String set;
                        if (count == 0) {
                            boolean set2 = (Boolean)value;
                            tameable.setTamed(set2);
                        } else if (count == 1 && (set = (String)value).length() > 0) {
                            Player owner = Bukkit.getServer().getPlayer(set);
                            if (owner == null) {
                                OfflinePlayer offlinePlayer = Bukkit.getServer().getOfflinePlayer(set);
                                if (offlinePlayer != null) {
                                    tameable.setOwner((AnimalTamer)offlinePlayer);
                                }
                            } else {
                                tameable.setOwner((AnimalTamer)owner);
                            }
                        }
                        ++count;
                    }
                }
                if (entity instanceof Attributable && list.size() >= 6) {
                    Attributable attributable = (Attributable)entity;
                    List attributes = (List)list.get(5);
                    for (Object value : attributes) {
                        List attributeData = (List)value;
                        Attribute attribute = (Attribute)attributeData.get(0);
                        Double baseValue = (Double)attributeData.get(1);
                        List attributeModifiers = (List)attributeData.get(2);
                        AttributeInstance entityAttribute = attributable.getAttribute(attribute);
                        if (entityAttribute == null) continue;
                        entityAttribute.setBaseValue(baseValue.doubleValue());
                        for (Object modifier : entityAttribute.getModifiers()) {
                            entityAttribute.removeModifier(modifier);
                        }
                        for (Object modifier : attributeModifiers) {
                            Map serializedModifier = (Map)modifier;
                            entityAttribute.addModifier(AttributeModifier.deserialize((Map)serializedModifier));
                        }
                    }
                }
                if (entity instanceof LivingEntity && list.size() >= 7) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    List details = (List)list.get(6);
                    int count2 = 0;
                    for (Object value : details) {
                        boolean set;
                        if (count2 == 0) {
                            set = (Boolean)value;
                            livingEntity.setRemoveWhenFarAway(set);
                        } else if (count2 == 1) {
                            set = (Boolean)value;
                            livingEntity.setCanPickupItems(set);
                        }
                        ++count2;
                    }
                }
                int count3 = 0;
                for (Object value : data) {
                    if (entity instanceof Creeper) {
                        Creeper creeper = (Creeper)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            creeper.setPowered(set);
                        }
                    } else if (entity instanceof Enderman) {
                        Enderman enderman = (Enderman)entity;
                        if (count3 == 1) {
                            String blockDataString = (String)value;
                            BlockData blockData = Bukkit.getServer().createBlockData(blockDataString);
                            enderman.setCarriedBlock(blockData);
                        }
                    } else if (entity instanceof IronGolem) {
                        IronGolem irongolem = (IronGolem)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            irongolem.setPlayerCreated(set);
                        }
                    } else if (entity instanceof Cat) {
                        Cat cat = (Cat)entity;
                        if (count3 == 0) {
                            Cat.Type set = (Cat.Type)value;
                            cat.setCatType(set);
                        } else if (count3 == 1) {
                            DyeColor set = (DyeColor)value;
                            cat.setCollarColor(set);
                        }
                    } else if (entity instanceof Fox) {
                        Fox fox = (Fox)entity;
                        if (count3 == 0) {
                            Fox.Type set = (Fox.Type)value;
                            fox.setFoxType(set);
                        } else if (count3 == 1) {
                            boolean set = (Boolean)value;
                            fox.setSitting(set);
                        }
                    } else if (entity instanceof Panda) {
                        Panda panda = (Panda)entity;
                        if (count3 == 0) {
                            Panda.Gene set = (Panda.Gene)value;
                            panda.setMainGene(set);
                        } else if (count3 == 1) {
                            Panda.Gene set = (Panda.Gene)value;
                            panda.setHiddenGene(set);
                        }
                    } else if (entity instanceof Pig) {
                        Pig pig = (Pig)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            pig.setSaddle(set);
                        }
                    } else if (entity instanceof Sheep) {
                        Sheep sheep = (Sheep)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            sheep.setSheared(set);
                        } else if (count3 == 1) {
                            DyeColor set = (DyeColor)value;
                            sheep.setColor(set);
                        }
                    } else if (entity instanceof MushroomCow) {
                        MushroomCow mushroomCow = (MushroomCow)entity;
                        if (count3 == 0) {
                            MushroomCow.Variant set = (MushroomCow.Variant)value;
                            mushroomCow.setVariant(set);
                        }
                    } else if (entity instanceof Slime) {
                        Slime slime = (Slime)entity;
                        if (count3 == 0) {
                            int set = (Integer)value;
                            slime.setSize(set);
                        }
                    } else if (entity instanceof Parrot) {
                        Parrot parrot = (Parrot)entity;
                        if (count3 == 0) {
                            Parrot.Variant set = (Parrot.Variant)value;
                            parrot.setVariant(set);
                        }
                    } else if (entity instanceof TropicalFish) {
                        TropicalFish tropicalFish = (TropicalFish)entity;
                        if (count3 == 0) {
                            DyeColor set = (DyeColor)value;
                            tropicalFish.setBodyColor(set);
                        } else if (count3 == 1) {
                            TropicalFish.Pattern set = (TropicalFish.Pattern)value;
                            tropicalFish.setPattern(set);
                        } else if (count3 == 2) {
                            DyeColor set = (DyeColor)value;
                            tropicalFish.setPatternColor(set);
                        }
                    } else if (entity instanceof Phantom) {
                        Phantom phantom = (Phantom)entity;
                        if (count3 == 0) {
                            int set = (Integer)value;
                            phantom.setSize(set);
                        }
                    } else if (entity instanceof AbstractVillager) {
                        AbstractVillager abstractVillager = (AbstractVillager)entity;
                        if (count3 == 0) {
                            if (abstractVillager instanceof Villager) {
                                Villager villager = (Villager)abstractVillager;
                                Villager.Profession set = (Villager.Profession)value;
                                villager.setProfession(set);
                            }
                        } else if (count3 == 1) {
                            if (abstractVillager instanceof Villager && value instanceof Villager.Type) {
                                Villager villager = (Villager)abstractVillager;
                                Villager.Type set = (Villager.Type)value;
                                villager.setVillagerType(set);
                            }
                        } else if (count3 == 2) {
                            ArrayList<MerchantRecipe> merchantRecipes = new ArrayList<MerchantRecipe>();
                            List set = (List)value;
                            for (Object recipes : set) {
                                List recipe = (List)recipes;
                                List itemMap = (List)recipe.get(0);
                                ItemStack result = ItemStack.deserialize((Map)((Map)itemMap.get(0)));
                                List metadata = (List)itemMap.get(1);
                                Object[] populatedStack = Rollback.populateItemStack(result, metadata);
                                result = (ItemStack)populatedStack[2];
                                int uses = (Integer)recipe.get(1);
                                int maxUses = (Integer)recipe.get(2);
                                boolean experienceReward = (Boolean)recipe.get(3);
                                ArrayList<ItemStack> merchantIngredients = new ArrayList<ItemStack>();
                                List ingredients = (List)recipe.get(4);
                                for (Object ingredient : ingredients) {
                                    List ingredientMap = (List)ingredient;
                                    ItemStack item = ItemStack.deserialize((Map)((Map)ingredientMap.get(0)));
                                    List itemMetaData = (List)ingredientMap.get(1);
                                    populatedStack = Rollback.populateItemStack(item, itemMetaData);
                                    item = (ItemStack)populatedStack[2];
                                    merchantIngredients.add(item);
                                }
                                MerchantRecipe merchantRecipe = new MerchantRecipe(result, uses, maxUses, experienceReward);
                                if (recipe.size() > 6) {
                                    int villagerExperience = (Integer)recipe.get(5);
                                    float priceMultiplier = ((Float)recipe.get(6)).floatValue();
                                    merchantRecipe = new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
                                }
                                merchantRecipe.setIngredients(merchantIngredients);
                                merchantRecipes.add(merchantRecipe);
                            }
                            if (!merchantRecipes.isEmpty()) {
                                abstractVillager.setRecipes(merchantRecipes);
                            }
                        } else {
                            Villager villager = (Villager)abstractVillager;
                            if (count3 == 3) {
                                int set = (Integer)value;
                                villager.setVillagerLevel(set);
                            } else if (count3 == 4) {
                                int set = (Integer)value;
                                villager.setVillagerExperience(set);
                            }
                        }
                    } else if (entity instanceof Raider) {
                        Raider raider = (Raider)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            raider.setPatrolLeader(set);
                        }
                        if (entity instanceof Spellcaster && count3 == 1) {
                            Spellcaster spellcaster = (Spellcaster)entity;
                            Spellcaster.Spell set = (Spellcaster.Spell)value;
                            spellcaster.setSpell(set);
                        }
                    } else if (entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            wolf.setSitting(set);
                        } else if (count3 == 1) {
                            DyeColor set = (DyeColor)value;
                            wolf.setCollarColor(set);
                        }
                    } else if (entity instanceof ZombieVillager) {
                        ZombieVillager zombieVillager = (ZombieVillager)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            zombieVillager.setBaby(set);
                        } else if (count3 == 1) {
                            Villager.Profession set = (Villager.Profession)value;
                            zombieVillager.setVillagerProfession(set);
                        }
                    } else if (entity instanceof Zombie) {
                        Zombie zombie = (Zombie)entity;
                        if (count3 == 0) {
                            boolean set = (Boolean)value;
                            zombie.setBaby(set);
                        }
                    } else if (entity instanceof AbstractHorse) {
                        AbstractHorse abstractHorse = (AbstractHorse)entity;
                        if (count3 == 0 && value != null) {
                            boolean set = (Boolean)value;
                            if (entity instanceof ChestedHorse) {
                                ChestedHorse chestedHorse = (ChestedHorse)entity;
                                chestedHorse.setCarryingChest(set);
                            }
                        } else if (count3 == 1 && value != null) {
                            Horse.Color set = (Horse.Color)value;
                            if (entity instanceof Horse) {
                                Horse horse = (Horse)entity;
                                horse.setColor(set);
                            }
                        } else if (count3 == 2) {
                            int set = (Integer)value;
                            abstractHorse.setDomestication(set);
                        } else if (count3 == 3) {
                            double set = (Double)value;
                            abstractHorse.setJumpStrength(set);
                        } else if (count3 == 4) {
                            int set = (Integer)value;
                            abstractHorse.setMaxDomestication(set);
                        } else if (count3 == 5 && value != null) {
                            Horse.Style set = (Horse.Style)value;
                            Horse horse = (Horse)entity;
                            horse.setStyle(set);
                        }
                        if (entity instanceof Horse) {
                            Horse horse = (Horse)entity;
                            if (count3 == 8) {
                                if (value != null) {
                                    ItemStack set = ItemStack.deserialize((Map)((Map)value));
                                    horse.getInventory().setSaddle(set);
                                }
                            } else if (count3 == 9) {
                                Horse.Color set = (Horse.Color)value;
                                horse.setColor(set);
                            } else if (count3 == 10) {
                                Horse.Style set = (Horse.Style)value;
                                horse.setStyle(set);
                            } else if (count3 == 11) {
                                if (value != null) {
                                    ItemStack set = ItemStack.deserialize((Map)((Map)value));
                                    horse.getInventory().setArmor(set);
                                }
                            } else if (count3 == 12 && value != null) {
                                ItemMeta itemMeta;
                                Color set = Color.deserialize((Map)((Map)value));
                                ItemStack armor = horse.getInventory().getArmor();
                                if (armor != null && (itemMeta = armor.getItemMeta()) instanceof LeatherArmorMeta) {
                                    LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
                                    leatherArmorMeta.setColor(set);
                                    armor.setItemMeta((ItemMeta)leatherArmorMeta);
                                }
                            }
                        } else if (entity instanceof ChestedHorse) {
                            if (count3 == 7) {
                                ChestedHorse chestedHorse = (ChestedHorse)entity;
                                boolean set = (Boolean)value;
                                chestedHorse.setCarryingChest(set);
                            }
                            if (entity instanceof Llama) {
                                Llama llama = (Llama)entity;
                                if (count3 == 8) {
                                    if (value != null) {
                                        ItemStack set = ItemStack.deserialize((Map)((Map)value));
                                        llama.getInventory().setDecor(set);
                                    }
                                } else if (count3 == 9) {
                                    Llama.Color set = (Llama.Color)value;
                                    llama.setColor(set);
                                }
                            }
                        }
                    } else if (entity instanceof Bee) {
                        Bee bee = (Bee)entity;
                        if (count3 == 0) {
                            int set = (Integer)value;
                            bee.setAnger(set);
                        } else if (count3 == 1) {
                            boolean set = (Boolean)value;
                            bee.setHasNectar(set);
                        } else if (count3 == 2) {
                            boolean set = (Boolean)value;
                            bee.setHasStung(set);
                        }
                    } else {
                        BukkitAdapter.ADAPTER.setEntityMeta(entity, value, count3);
                    }
                    ++count3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, block.getLocation());
    }
}

