/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility.serialize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.Util;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;

public class ItemMetaHandler {
    public static String getEnchantmentName(Enchantment enchantment, int level) {
        Object name = enchantment.getKey().getKey();
        switch (name) {
            case "vanishing_curse": {
                name = "Curse of Vanishing";
                break;
            }
            case "binding_curse": {
                name = "Curse of Binding";
                break;
            }
            default: {
                name = Util.capitalize(((String)name).replace("_", " "), true);
            }
        }
        if (enchantment.getMaxLevel() > 1) {
            name = (String)name + " " + ItemMetaHandler.getEnchantmentLevel(level);
        }
        return name;
    }

    private static String getEnchantmentLevel(int level) {
        switch (level) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return Integer.toString(level);
    }

    private static Map<Enchantment, Integer> getEnchantments(ItemMeta itemMeta) {
        if (itemMeta == null) {
            return null;
        }
        if (itemMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageEngine = (EnchantmentStorageMeta)itemMeta;
            return enchantmentStorageEngine.getStoredEnchants();
        }
        return itemMeta.getEnchants();
    }

    public static List<String> getEnchantments(ItemStack item, String displayName) {
        ArrayList<String> result = new ArrayList<String>();
        ItemMeta itemMeta = item.getItemMeta();
        Map<Enchantment, Integer> enchantments = ItemMetaHandler.getEnchantments(itemMeta);
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            Integer level = entry.getValue();
            result.add(ItemMetaHandler.getEnchantmentName(enchantment, level));
        }
        if (itemMeta.hasLore()) {
            for (String lore : itemMeta.getLore()) {
                result.add(Color.DARK_PURPLE + "\u00a7o" + lore);
            }
        }
        return result;
    }

    public static List<List<Map<String, Object>>> seralize(ItemStack item, Material type, String faceData, int slot) {
        HashMap<String, Object> meta;
        ArrayList<List<Map<String, Object>>> metadata = new ArrayList<List<Map<String, Object>>>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList modifiers = new ArrayList();
        if (item.hasItemMeta() && item.getItemMeta() != null) {
            LeatherArmorMeta subMeta;
            LeatherArmorMeta meta2;
            ItemMeta itemMeta = item.getItemMeta().clone();
            if (itemMeta.hasAttributeModifiers()) {
                for (Map.Entry entry : itemMeta.getAttributeModifiers().entries()) {
                    Iterator attributeList = new HashMap<Attribute, Map>();
                    Attribute attribute = (Attribute)entry.getKey();
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    itemMeta.removeAttributeModifier(attribute, modifier);
                    attributeList.put(attribute, modifier.serialize());
                    modifiers.add(attributeList);
                }
            }
            if (itemMeta instanceof LeatherArmorMeta) {
                meta2 = (LeatherArmorMeta)itemMeta;
                subMeta = meta2.clone();
                meta2.setColor(Bukkit.getServer().getItemFactory().getDefaultLeatherColor());
                list.add(meta2.serialize());
                metadata.add(list);
                list = new ArrayList();
                list.add(subMeta.getColor().serialize());
                metadata.add(list);
            } else if (itemMeta instanceof PotionMeta) {
                meta2 = (PotionMeta)itemMeta;
                subMeta = meta2.clone();
                meta2.setColor(null);
                meta2.clearCustomEffects();
                list.add(meta2.serialize());
                if (subMeta.hasColor()) {
                    list.add(subMeta.getColor().serialize());
                }
                metadata.add(list);
                if (subMeta.hasCustomEffects()) {
                    for (FireworkEffect effect : subMeta.getCustomEffects()) {
                        list = new ArrayList();
                        list.add(effect.serialize());
                        metadata.add(list);
                    }
                }
            } else if (itemMeta instanceof FireworkMeta) {
                meta2 = (FireworkMeta)itemMeta;
                subMeta = meta2.clone();
                meta2.clearEffects();
                list.add(meta2.serialize());
                metadata.add(list);
                if (subMeta.hasEffects()) {
                    for (FireworkEffect effect : subMeta.getEffects()) {
                        ItemMetaHandler.deserializeFireworkEffect(effect, metadata);
                    }
                }
            } else if (itemMeta instanceof FireworkEffectMeta) {
                meta2 = (FireworkEffectMeta)itemMeta;
                subMeta = meta2.clone();
                meta2.setEffect(null);
                list.add(meta2.serialize());
                metadata.add(list);
                if (subMeta.hasEffect()) {
                    FireworkEffect effect = subMeta.getEffect();
                    ItemMetaHandler.deserializeFireworkEffect(effect, metadata);
                }
            } else if (itemMeta instanceof BannerMeta) {
                meta2 = (BannerMeta)itemMeta;
                subMeta = (BannerMeta)meta2.clone();
                meta2.setPatterns(new ArrayList());
                list.add(meta2.serialize());
                metadata.add(list);
                for (Pattern pattern : subMeta.getPatterns()) {
                    list = new ArrayList();
                    list.add(pattern.serialize());
                    metadata.add(list);
                }
            } else if (itemMeta instanceof CrossbowMeta) {
                meta2 = (CrossbowMeta)itemMeta;
                subMeta = (CrossbowMeta)meta2.clone();
                meta2.setChargedProjectiles(null);
                list.add(meta2.serialize());
                metadata.add(list);
                if (subMeta.hasChargedProjectiles()) {
                    list = new ArrayList();
                    for (ItemStack chargedProjectile : subMeta.getChargedProjectiles()) {
                        Map<String, Object> itemMap = Util.serializeItemStack(chargedProjectile, null, slot);
                        if (itemMap.size() <= 0) continue;
                        list.add(itemMap);
                    }
                    metadata.add(list);
                }
            } else if (itemMeta instanceof MapMeta) {
                meta2 = (MapMeta)itemMeta;
                subMeta = meta2.clone();
                meta2.setColor(null);
                list.add(meta2.serialize());
                metadata.add(list);
                if (subMeta.hasColor()) {
                    list = new ArrayList();
                    list.add(subMeta.getColor().serialize());
                    metadata.add(list);
                }
            } else if (itemMeta instanceof SuspiciousStewMeta) {
                meta2 = (SuspiciousStewMeta)itemMeta;
                subMeta = meta2.clone();
                meta2.clearCustomEffects();
                list.add(meta2.serialize());
                metadata.add(list);
                if (subMeta.hasCustomEffects()) {
                    for (FireworkEffect effect : subMeta.getCustomEffects()) {
                        list = new ArrayList();
                        list.add(effect.serialize());
                        metadata.add(list);
                    }
                }
            } else if (!BukkitAdapter.ADAPTER.getItemMeta(itemMeta, list, metadata, slot)) {
                list.add(itemMeta.serialize());
                metadata.add(list);
            }
        }
        if (type != null && type.equals((Object)Material.ARMOR_STAND)) {
            meta = new HashMap<String, Object>();
            meta.put("slot", slot);
            list = new ArrayList();
            list.add(meta);
            metadata.add(list);
        }
        if (faceData != null && faceData.length() > 0) {
            meta = new HashMap();
            meta.put("facing", faceData);
            list = new ArrayList();
            list.add(meta);
            metadata.add(list);
        }
        if (modifiers.size() > 0) {
            meta = new HashMap();
            meta.put("modifiers", modifiers);
            list = new ArrayList();
            list.add(meta);
            metadata.add(list);
        }
        return metadata;
    }

    private static void deserializeFireworkEffect(FireworkEffect effect, List<List<Map<String, Object>>> metadata) {
        ArrayList<Map> colorList = new ArrayList<Map>();
        ArrayList<Map> fadeList = new ArrayList<Map>();
        ArrayList list = new ArrayList();
        for (org.bukkit.Color color : effect.getColors()) {
            colorList.add(color.serialize());
        }
        for (org.bukkit.Color color : effect.getFadeColors()) {
            fadeList.add(color.serialize());
        }
        HashMap<String, Object> hasCheck = new HashMap<String, Object>();
        hasCheck.put("type", effect.getType());
        hasCheck.put("flicker", effect.hasFlicker());
        hasCheck.put("trail", effect.hasTrail());
        list.add(hasCheck);
        metadata.add(list);
        metadata.add(colorList);
        metadata.add(fadeList);
    }
}

