/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api;

import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.semver.SemanticVersion;

public class VersionProvider {
    private static final String VERSION = SkinsRestorerProvider.get().getVersion();
    private static final String COMMIT = SkinsRestorerProvider.get().getCommit();
    private static final String COMMIT_SHORT = SkinsRestorerProvider.get().getCommitShort();
    private static final String VERSION_INFO = String.format("SkinsRestorer %s (%s)", VERSION, COMMIT_SHORT);
    private static final SemanticVersion SEMANTIC_VERSION = SemanticVersion.fromString(VERSION);

    public static boolean isCompatibleWith(String version) {
        SemanticVersion semVer = SemanticVersion.fromString(version);
        int[] versionParts = semVer.getVersion();
        if (versionParts.length < 1) {
            throw new IllegalArgumentException("Version must have at least one part");
        }
        return versionParts[0] == SEMANTIC_VERSION.getVersion()[0];
    }

    public static String getVersionInfo() {
        return VERSION_INFO;
    }

    public static int[] getSemanticVersion() {
        return SEMANTIC_VERSION.getVersion();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getCommit() {
        return COMMIT;
    }
}

