/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.semver;

import java.util.Arrays;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;

@ApiStatus.Internal
public class SemanticVersion {
    private final int[] version;

    public SemanticVersion(int major, int minor, int patch) {
        this(new int[]{major, minor, patch});
    }

    public static SemanticVersion fromString(String version) {
        version = version.replace("v", "");
        version = version.replace("-SNAPSHOT", "");
        String[] split = version.split("\\.");
        return new SemanticVersion(Arrays.stream(split).mapToInt(Integer::parseInt).toArray());
    }

    public boolean isNewerThan(SemanticVersion otherVersion) {
        int i = 0;
        for (int version : this.version) {
            if (i == otherVersion.version.length) {
                return true;
            }
            int otherVersionPart = otherVersion.version[i];
            if (version > otherVersionPart) {
                return true;
            }
            if (version < otherVersionPart) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        return String.join((CharSequence)".", (CharSequence[])Arrays.stream(this.version).mapToObj(String::valueOf).toArray(String[]::new));
    }

    public int[] getVersion() {
        return this.version;
    }

    public SemanticVersion(int[] version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion other = (SemanticVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getVersion(), other.getVersion());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SemanticVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getVersion());
        return result;
    }
}

