/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.util.Collection;
import java.util.function.Consumer;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.semver.SemanticVersion;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.multipaper.MultiPaperUtil;
import net.skinsrestorer.bukkit.paper.PaperSkinApplier;
import net.skinsrestorer.bukkit.skinrefresher.MappingSpigotSkinRefresher;
import net.skinsrestorer.bukkit.skinrefresher.PaperSkinRefresher;
import net.skinsrestorer.bukkit.skinrefresher.SpigotSkinRefresher;
import net.skinsrestorer.bukkit.skinrefresher.ViaWorkaround;
import net.skinsrestorer.bukkit.spigot.SpigotPassengerUtil;
import net.skinsrestorer.bukkit.spigot.SpigotUtil;
import net.skinsrestorer.bukkit.utils.BukkitPropertyApplier;
import net.skinsrestorer.bukkit.utils.BukkitReflection;
import net.skinsrestorer.bukkit.utils.NMSVersion;
import net.skinsrestorer.bukkit.utils.NoMappingException;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import net.skinsrestorer.bukkit.v1_7.BukkitLegacyPropertyApplier;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.api.event.EventBusImpl;
import net.skinsrestorer.shared.api.event.SkinApplyEventImpl;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.info.ClassInfo;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SkinApplierBukkit
implements SkinApplierAccess<Player> {
    private static final boolean IS_MODERN_AUTH_LIB = ReflectionUtil.classExists("com.mojang.authlib.GameProfile");
    private static final SkinApplyBukkitAdapter applyAdapter = SkinApplierBukkit.selectSkinApplyAdapter();
    private final SRBukkitAdapter adapter;
    private final SRLogger logger;
    private final SettingsManager settings;
    private final Server server;
    private final EventBusImpl eventBus;
    private Consumer<Player> refresh;

    private static SkinApplyBukkitAdapter selectSkinApplyAdapter() {
        if (IS_MODERN_AUTH_LIB) {
            return new BukkitPropertyApplier();
        }
        return new BukkitLegacyPropertyApplier();
    }

    protected Consumer<Player> detectRefresh(Server server) throws InitializeException {
        if (this.isPaper()) {
            boolean viaVersionExists = this.adapter.isPluginEnabled("ViaVersion");
            boolean protocolSupportExists = this.adapter.isPluginEnabled("ProtocolSupport");
            if (viaVersionExists || protocolSupportExists) {
                this.logger.debug(SRLogLevel.WARNING, "Unsupported plugin (ViaVersion or ProtocolSupport) detected, forcing SpigotSkinRefresher");
                return this.selectSpigotRefresher(server);
            }
            try {
                this.logger.debug("Using PaperSkinRefresher");
                return new PaperSkinRefresher();
            }
            catch (NoMappingException e) {
                throw e;
            }
            catch (InitializeException e) {
                this.logger.severe("PaperSkinRefresher failed! (Are you using hybrid software?) Only limited support can be provided. Falling back to SpigotSkinRefresher.");
            }
        }
        return this.selectSpigotRefresher(server);
    }

    private Consumer<Player> selectSpigotRefresher(Server server) throws InitializeException {
        boolean viaWorkaround;
        boolean bl = viaWorkaround = this.adapter.isPluginEnabled("ViaBackwards") && ViaWorkaround.isProtocolNewer();
        if (viaWorkaround) {
            this.logger.debug("Activating ViaBackwards workaround.");
        }
        if (NMSVersion.SERVER_VERSION.isNewerThan(new SemanticVersion(1, 17, 1))) {
            this.logger.debug("Using MappingSpigotSkinRefresher");
            return new MappingSpigotSkinRefresher(server, viaWorkaround);
        }
        this.logger.debug("Using SpigotSkinRefresher");
        return new SpigotSkinRefresher(this.adapter, viaWorkaround);
    }

    @Override
    public void applySkin(Player player, SkinProperty property) {
        if (!player.isOnline()) {
            return;
        }
        this.adapter.runAsync(() -> {
            SkinApplyEventImpl applyEvent = new SkinApplyEventImpl(player, property);
            this.eventBus.callEvent(applyEvent);
            if (applyEvent.isCancelled()) {
                return;
            }
            this.adapter.runSyncToPlayer(player, () -> {
                applyAdapter.applyProperty(player, applyEvent.getProperty());
                this.adapter.runAsync(() -> this.updateSkin(player, applyEvent.getProperty()));
            });
        });
    }

    public void updateSkin(Player player, SkinProperty property) {
        if (!player.isOnline()) {
            return;
        }
        this.adapter.getSchedulerProvider().runSyncToEntity(this.server, (Plugin)this.adapter.getPluginInstance(), (Entity)player, () -> {
            this.ejectPassengers(player);
            if (ReflectionUtil.classExists("com.destroystokyo.paper.profile.PlayerProfile") && PaperSkinApplier.hasProfileMethod()) {
                PaperSkinApplier.applySkin(player, property);
                return;
            }
            for (Player player2 : this.getOnlinePlayers()) {
                try {
                    player2.hidePlayer((Plugin)this.adapter.getPluginInstance(), player);
                }
                catch (NoSuchMethodError ignored) {
                    player2.hidePlayer(player);
                }
                try {
                    player2.showPlayer((Plugin)this.adapter.getPluginInstance(), player);
                }
                catch (NoSuchMethodError ignored) {
                    player2.showPlayer(player);
                }
            }
            this.refresh.accept(player);
        });
    }

    private void ejectPassengers(Player player) {
        if (ClassInfo.get().isSpigot() && SpigotUtil.hasPassengerMethods()) {
            Entity vehicle = player.getVehicle();
            SpigotPassengerUtil.refreshPassengers(this.adapter.getPluginInstance(), player, vehicle, this.settings);
        }
    }

    private boolean isPaper() {
        if (ClassInfo.get().isPaper() && NMSVersion.SERVER_VERSION.isNewerThan(new SemanticVersion(1, 11, 2))) {
            if (this.hasPaperMethods()) {
                return true;
            }
            this.logger.debug(SRLogLevel.WARNING, "Paper detected, but the methods are missing. Disabling Paper Refresher.");
            return false;
        }
        return false;
    }

    private boolean hasPaperMethods() {
        try {
            BukkitReflection.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("refreshPlayer", new Class[0]);
            return true;
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    private Collection<? extends Player> getOnlinePlayers() {
        try {
            return MultiPaperUtil.getOnlinePlayers();
        }
        catch (Throwable e) {
            return this.server.getOnlinePlayers();
        }
    }

    @Inject
    public SkinApplierBukkit(SRBukkitAdapter adapter, SRLogger logger, SettingsManager settings, Server server, EventBusImpl eventBus) {
        this.adapter = adapter;
        this.logger = logger;
        this.settings = settings;
        this.server = server;
        this.eventBus = eventBus;
    }

    public static SkinApplyBukkitAdapter getApplyAdapter() {
        return applyAdapter;
    }

    public Consumer<Player> getRefresh() {
        return this.refresh;
    }

    protected void setRefresh(Consumer<Player> refresh) {
        this.refresh = refresh;
    }
}

