/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.command;

import net.skinsrestorer.bukkit.command.SRBukkitCommand;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.utils.ComponentHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.help.HelpTopic;

public class SRHelpTopic
extends HelpTopic {
    private final SRBukkitCommand srbukkitCommand;
    private final WrapperBukkit wrapper;
    private final SkinsRestorerLocale locale;

    public boolean canSee(@NotNull CommandSender player) {
        return this.srbukkitCommand.testPermissionSilent(player);
    }

    @NotNull
    public String getName() {
        return "/" + this.srbukkitCommand.getMeta().getRootName();
    }

    @NotNull
    public String getShortText() {
        return ComponentHelper.convertJsonToLegacy(this.locale.getMessage(this.locale.getDefaultForeign(), this.srbukkitCommand.getMeta().getRootHelp().getCommandDescription()));
    }

    @NotNull
    public String getFullText(@NotNull CommandSender forWho) {
        SRCommandSender sender = this.wrapper.commandSender(forWho);
        return String.join((CharSequence)"\n", (CharSequence[])this.srbukkitCommand.getExecutor().getManager().getHelpMessage(this.srbukkitCommand.getMeta().getRootName(), sender).stream().map(ComponentHelper::convertJsonToLegacy).toArray(String[]::new));
    }

    public SRHelpTopic(SRBukkitCommand srbukkitCommand, WrapperBukkit wrapper, SkinsRestorerLocale locale) {
        this.srbukkitCommand = srbukkitCommand;
        this.wrapper = wrapper;
        this.locale = locale;
    }
}

