/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.paper;

import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.UUID;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.listeners.LoginProfileListenerAdapter;
import net.skinsrestorer.shared.listeners.event.SRLoginProfileEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

public class PaperPlayerJoinEvent
implements Listener {
    private final LoginProfileListenerAdapter<Void> adapter;

    public static boolean isAvailable() {
        try {
            AsyncPlayerPreLoginEvent.class.getMethod("getPlayerProfile", new Class[0]);
            return true;
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    @EventHandler
    public void onAsyncPreLogin(AsyncPlayerPreLoginEvent event) {
        this.adapter.handleLogin(this.wrap(event));
    }

    private SRLoginProfileEvent<Void> wrap(final AsyncPlayerPreLoginEvent event) {
        return new SRLoginProfileEvent<Void>(){

            @Override
            public boolean hasOnlineProperties() {
                return !event.getPlayerProfile().getProperties().isEmpty();
            }

            @Override
            public UUID getPlayerUniqueId() {
                return event.getUniqueId();
            }

            @Override
            public String getPlayerName() {
                return event.getName();
            }

            @Override
            public boolean isCancelled() {
                return event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED;
            }

            @Override
            public void setResultProperty(SkinProperty property) {
                event.getPlayerProfile().setProperty(new ProfileProperty("textures", property.getValue(), property.getSignature()));
            }

            @Override
            public Void runAsync(Runnable runnable) {
                runnable.run();
                return null;
            }
        };
    }

    @Inject
    public PaperPlayerJoinEvent(LoginProfileListenerAdapter<Void> adapter) {
        this.adapter = adapter;
    }
}

