/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import org.bukkit.entity.Player;

public class BukkitPropertyApplier
implements SkinApplyBukkitAdapter {
    @Override
    public void applyProperty(Player player, SkinProperty property) {
        try {
            GameProfile profile = this.getGameProfile(player, GameProfile.class);
            profile.getProperties().removeAll((Object)"textures");
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", property.getValue(), property.getSignature()));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(Player player) {
        try {
            Collection properties = this.getGameProfile(player, GameProfile.class).getProperties().values();
            return properties.stream().filter(property -> this.getPropertyName((Property)property).equals("textures")).map(this::convertToSRProperty).findFirst();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private SkinProperty convertToSRProperty(Property property) {
        try {
            return SkinProperty.of(property.getValue(), property.getSignature());
        }
        catch (NoSuchMethodError t) {
            try {
                Method valueMethod = property.getClass().getMethod("value", new Class[0]);
                Method signatureMethod = property.getClass().getMethod("signature", new Class[0]);
                return SkinProperty.of((String)valueMethod.invoke((Object)property, new Object[0]), (String)signatureMethod.invoke((Object)property, new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getPropertyName(Property property) {
        try {
            return property.getName();
        }
        catch (NoSuchMethodError t) {
            try {
                Method nameMethod = property.getClass().getMethod("name", new Class[0]);
                return (String)nameMethod.invoke((Object)property, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

