/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.wrapper;

import java.util.Locale;
import java.util.UUID;
import net.skinsrestorer.bukkit.wrapper.WrapperCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRServerPlayer;
import net.skinsrestorer.shared.utils.LocaleParser;
import org.bukkit.entity.Player;

public class WrapperPlayer
extends WrapperCommandSender
implements SRServerPlayer {
    private final Player player;

    @Override
    public Locale getLocale() {
        try {
            return LocaleParser.parseLocale(this.player.getLocale()).orElseGet(() -> super.getLocale());
        }
        catch (NoSuchMethodError ignored) {
            return super.getLocale();
        }
    }

    @Override
    public <P> P getAs(Class<P> playerClass) {
        return playerClass.cast(this.player);
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean canSee(SRPlayer player) {
        return this.player.canSee(player.getAs(Player.class));
    }

    @Override
    public void closeInventory() {
        this.player.closeInventory();
    }

    protected WrapperPlayer(WrapperPlayerBuilder<?, ?> b) {
        super((WrapperCommandSender.WrapperCommandSenderBuilder<?, ?>)b);
        this.player = ((WrapperPlayerBuilder)b).player;
    }

    public static WrapperPlayerBuilder<?, ?> builder() {
        return new WrapperPlayerBuilderImpl();
    }

    public static abstract class WrapperPlayerBuilder<C extends WrapperPlayer, B extends WrapperPlayerBuilder<C, B>>
    extends WrapperCommandSender.WrapperCommandSenderBuilder<C, B> {
        private Player player;

        public B player(Player player) {
            this.player = player;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperPlayer.WrapperPlayerBuilder(super=" + super.toString() + ", player=" + this.player + ")";
        }
    }

    private static final class WrapperPlayerBuilderImpl
    extends WrapperPlayerBuilder<WrapperPlayer, WrapperPlayerBuilderImpl> {
        private WrapperPlayerBuilderImpl() {
        }

        @Override
        protected WrapperPlayerBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperPlayer build() {
            return new WrapperPlayer(this);
        }
    }
}

