/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bungee.SkinApplierBungee;
import net.skinsrestorer.bungee.command.SRBungeeCommand;
import net.skinsrestorer.bungee.listeners.ForceAliveListener;
import net.skinsrestorer.bungee.wrapper.WrapperBungee;
import net.skinsrestorer.shadow.bstats.bungeecord.Metrics;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.skinsrestorer.shared.commands.library.SRRegisterPayload;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.plugin.SRProxyAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;

public class SRBungeeAdapter
implements SRProxyAdapter<Plugin> {
    private final Injector injector;
    private final ProxyServer proxy;
    private final Plugin pluginInstance;
    private final BungeeAudiences adventure;

    @Override
    public Object createMetricsInstance() {
        return new Metrics(this.pluginInstance, 1686);
    }

    @Override
    public boolean isPluginEnabled(String pluginName) {
        return this.proxy.getPluginManager().getPlugin(pluginName) != null;
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.proxy.getScheduler().runAsync(this.pluginInstance, runnable);
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.proxy.getScheduler().schedule(this.pluginInstance, runnable, (long)delay, (long)interval, timeUnit);
    }

    @Override
    public void extendLifeTime(Plugin plugin, Object object) {
        this.proxy.getPluginManager().registerListener(plugin, (Listener)new ForceAliveListener(object));
    }

    @Override
    public String getPlatformVersion() {
        return this.proxy.getVersion();
    }

    @Override
    public String getPlatformName() {
        return this.proxy.getName();
    }

    @Override
    public String getPlatformVendor() {
        return "N/A";
    }

    @Override
    public Platform getPlatform() {
        return Platform.BUNGEE_CORD;
    }

    @Override
    public List<PluginInfo> getPlugins() {
        return this.proxy.getPluginManager().getPlugins().stream().map(p -> new PluginInfo(true, p.getDescription().getName(), p.getDescription().getVersion(), p.getDescription().getMain(), new String[]{p.getDescription().getAuthor()})).collect(Collectors.toList());
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return SkinApplierBungee.getApplyAdapter().getSkinProperty(player.getAs(ProxiedPlayer.class));
    }

    @Override
    public Collection<SRPlayer> getOnlinePlayers() {
        WrapperBungee wrapper = this.injector.getSingleton(WrapperBungee.class);
        return this.proxy.getPlayers().stream().map(wrapper::player).collect(Collectors.toList());
    }

    @Override
    public Optional<SRProxyPlayer> getPlayer(String name) {
        return Optional.ofNullable(this.proxy.getPlayer(name)).map(p -> this.injector.getSingleton(WrapperBungee.class).player((ProxiedPlayer)p));
    }

    @Override
    public void registerCommand(SRRegisterPayload<SRCommandSender> payload) {
        this.proxy.getPluginManager().registerCommand(this.pluginInstance, (Command)new SRBungeeCommand(payload, this.injector.getSingleton(WrapperBungee.class)));
    }

    @Inject
    public SRBungeeAdapter(Injector injector, ProxyServer proxy, Plugin pluginInstance, BungeeAudiences adventure) {
        this.injector = injector;
        this.proxy = proxy;
        this.pluginInstance = pluginInstance;
        this.adventure = adventure;
    }

    public Plugin getPluginInstance() {
        return this.pluginInstance;
    }

    public BungeeAudiences getAdventure() {
        return this.adventure;
    }
}

