/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.listeners;

import java.util.UUID;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.event.EventHandler;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.bungee.SRBungeeAdapter;
import net.skinsrestorer.bungee.SkinApplierBungee;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.listeners.LoginProfileListenerAdapter;
import net.skinsrestorer.shared.listeners.event.SRLoginProfileEvent;

public class LoginListener
implements Listener {
    private final SRBungeeAdapter plugin;
    private final SkinApplierBungee skinApplier;
    private final LoginProfileListenerAdapter<Void> adapter;

    @EventHandler(priority=32)
    public void onLogin(LoginEvent event) {
        this.adapter.handleLogin(this.wrap(event));
    }

    private SRLoginProfileEvent<Void> wrap(final LoginEvent event) {
        return new SRLoginProfileEvent<Void>(){

            @Override
            public boolean hasOnlineProperties() {
                return event.getConnection().isOnlineMode();
            }

            @Override
            public UUID getPlayerUniqueId() {
                return event.getConnection().getUniqueId();
            }

            @Override
            public String getPlayerName() {
                return event.getConnection().getName();
            }

            @Override
            public boolean isCancelled() {
                return event.isCancelled();
            }

            @Override
            public void setResultProperty(SkinProperty property) {
                LoginListener.this.skinApplier.applySkin(property, (InitialHandler)event.getConnection());
            }

            @Override
            public Void runAsync(Runnable runnable) {
                event.registerIntent(LoginListener.this.plugin.getPluginInstance());
                LoginListener.this.plugin.runAsync(() -> {
                    runnable.run();
                    event.completeIntent(LoginListener.this.plugin.getPluginInstance());
                });
                return null;
            }
        };
    }

    @Inject
    public LoginListener(SRBungeeAdapter plugin, SkinApplierBungee skinApplier, LoginProfileListenerAdapter<Void> adapter) {
        this.plugin = plugin;
        this.skinApplier = skinApplier;
        this.adapter = adapter;
    }
}

