/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.wrapper;

import net.md_5.bungee.api.CommandSender;
import net.skinsrestorer.bungee.SRBungeeAdapter;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.skinsrestorer.shared.subjects.AbstractSRCommandSender;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.Permission;
import net.skinsrestorer.shared.utils.Tristate;

public class WrapperCommandSender
extends AbstractSRCommandSender {
    private final SettingsManager settings;
    private final SkinsRestorerLocale locale;
    private final CommandSender sender;
    private final SRBungeeAdapter adapter;
    private final GsonComponentSerializer serializer = GsonComponentSerializer.gson();

    @Override
    public void sendMessage(String messageJson) {
        this.adapter.getAdventure().sender(this.sender).sendMessage((Component)this.serializer.deserialize(messageJson));
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return permission.checkPermission(this.settings, p -> {
            if (this.sender.hasPermission(p)) {
                return Tristate.TRUE;
            }
            return Tristate.UNDEFINED;
        });
    }

    @Override
    protected SkinsRestorerLocale getSRLocale() {
        return this.locale;
    }

    @Override
    protected SettingsManager getSettings() {
        return this.settings;
    }

    protected WrapperCommandSender(WrapperCommandSenderBuilder<?, ?> b) {
        super(b);
        this.settings = ((WrapperCommandSenderBuilder)b).settings;
        this.locale = ((WrapperCommandSenderBuilder)b).locale;
        this.sender = ((WrapperCommandSenderBuilder)b).sender;
        this.adapter = ((WrapperCommandSenderBuilder)b).adapter;
    }

    public static WrapperCommandSenderBuilder<?, ?> builder() {
        return new WrapperCommandSenderBuilderImpl();
    }

    public static abstract class WrapperCommandSenderBuilder<C extends WrapperCommandSender, B extends WrapperCommandSenderBuilder<C, B>>
    extends AbstractSRCommandSender.AbstractSRCommandSenderBuilder<C, B> {
        private SettingsManager settings;
        private SkinsRestorerLocale locale;
        private CommandSender sender;
        private SRBungeeAdapter adapter;

        public B settings(SettingsManager settings) {
            this.settings = settings;
            return (B)this.self();
        }

        public B locale(SkinsRestorerLocale locale) {
            this.locale = locale;
            return (B)this.self();
        }

        public B sender(CommandSender sender) {
            this.sender = sender;
            return (B)this.self();
        }

        public B adapter(SRBungeeAdapter adapter) {
            this.adapter = adapter;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperCommandSender.WrapperCommandSenderBuilder(super=" + super.toString() + ", settings=" + this.settings + ", locale=" + this.locale + ", sender=" + this.sender + ", adapter=" + this.adapter + ")";
        }
    }

    private static final class WrapperCommandSenderBuilderImpl
    extends WrapperCommandSenderBuilder<WrapperCommandSender, WrapperCommandSenderBuilderImpl> {
        private WrapperCommandSenderBuilderImpl() {
        }

        @Override
        protected WrapperCommandSenderBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperCommandSender build() {
            return new WrapperCommandSender(this);
        }
    }
}

