/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.wrapper;

import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.skinsrestorer.bungee.wrapper.WrapperCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;

public class WrapperPlayer
extends WrapperCommandSender
implements SRProxyPlayer {
    private final ProxiedPlayer player;

    @Override
    public Locale getLocale() {
        Locale playerLocale = this.player.getLocale();
        if (playerLocale == null) {
            return super.getLocale();
        }
        return playerLocale;
    }

    @Override
    public <P> P getAs(Class<P> playerClass) {
        return playerClass.cast(this.player);
    }

    @Override
    public Optional<String> getCurrentServer() {
        return Optional.ofNullable(this.player.getServer()).map(server -> server.getInfo().getName());
    }

    @Override
    public void sendDataToServer(String channel, byte[] data) {
        this.player.getServer().sendData(channel, data);
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean canSee(SRPlayer player) {
        return true;
    }

    protected WrapperPlayer(WrapperPlayerBuilder<?, ?> b) {
        super((WrapperCommandSender.WrapperCommandSenderBuilder<?, ?>)b);
        this.player = ((WrapperPlayerBuilder)b).player;
    }

    public static WrapperPlayerBuilder<?, ?> builder() {
        return new WrapperPlayerBuilderImpl();
    }

    public static abstract class WrapperPlayerBuilder<C extends WrapperPlayer, B extends WrapperPlayerBuilder<C, B>>
    extends WrapperCommandSender.WrapperCommandSenderBuilder<C, B> {
        private ProxiedPlayer player;

        public B player(ProxiedPlayer player) {
            this.player = player;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "WrapperPlayer.WrapperPlayerBuilder(super=" + super.toString() + ", player=" + this.player + ")";
        }
    }

    private static final class WrapperPlayerBuilderImpl
    extends WrapperPlayerBuilder<WrapperPlayer, WrapperPlayerBuilderImpl> {
        private WrapperPlayerBuilderImpl() {
        }

        @Override
        protected WrapperPlayerBuilderImpl self() {
            return this;
        }

        @Override
        public WrapperPlayer build() {
            return new WrapperPlayer(this);
        }
    }
}

