/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.brigadier.builder;

import net.skinsrestorer.shadow.brigadier.arguments.ArgumentType;
import net.skinsrestorer.shadow.brigadier.builder.ArgumentBuilder;
import net.skinsrestorer.shadow.brigadier.suggestion.SuggestionProvider;
import net.skinsrestorer.shadow.brigadier.tree.ArgumentCommandNode;
import net.skinsrestorer.shadow.brigadier.tree.CommandNode;

public class RequiredArgumentBuilder<S, T>
extends ArgumentBuilder<S, RequiredArgumentBuilder<S, T>> {
    private final String name;
    private final ArgumentType<T> type;
    private SuggestionProvider<S> suggestionsProvider = null;

    private RequiredArgumentBuilder(String name, ArgumentType<T> type) {
        this.name = name;
        this.type = type;
    }

    public static <S, T> RequiredArgumentBuilder<S, T> argument(String name, ArgumentType<T> type) {
        return new RequiredArgumentBuilder<S, T>(name, type);
    }

    public RequiredArgumentBuilder<S, T> suggests(SuggestionProvider<S> provider) {
        this.suggestionsProvider = provider;
        return this.getThis();
    }

    public SuggestionProvider<S> getSuggestionsProvider() {
        return this.suggestionsProvider;
    }

    @Override
    protected RequiredArgumentBuilder<S, T> getThis() {
        return this;
    }

    public ArgumentType<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ArgumentCommandNode<S, T> build() {
        ArgumentCommandNode result = new ArgumentCommandNode(this.getName(), this.getType(), this.getCommand(), this.getRequirement(), this.getRedirect(), this.getRedirectModifier(), this.isFork(), this.getSuggestionsProvider());
        for (CommandNode argument : this.getArguments()) {
            result.addChild(argument);
        }
        return result;
    }
}

