/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.configme.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.configme.properties.BaseProperty;
import net.skinsrestorer.shadow.configme.properties.convertresult.ConvertErrorRecorder;
import net.skinsrestorer.shadow.configme.properties.types.PropertyType;
import net.skinsrestorer.shadow.configme.resource.PropertyReader;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class ListProperty<T>
extends BaseProperty<List<T>> {
    private final PropertyType<T> type;

    @SafeVarargs
    public ListProperty(@NotNull String path, @NotNull PropertyType<T> type, T ... defaultValue) {
        this(path, type, Arrays.asList(defaultValue));
    }

    public ListProperty(@NotNull String path, @NotNull PropertyType<T> type, @NotNull List<T> defaultValue) {
        super(path, Collections.unmodifiableList(defaultValue));
        Objects.requireNonNull(type, "type");
        this.type = type;
    }

    @Override
    @Nullable
    protected List<T> getFromReader(@NotNull PropertyReader reader, @NotNull ConvertErrorRecorder errorRecorder) {
        List<?> list = reader.getList(this.getPath());
        if (list != null) {
            return Collections.unmodifiableList(list.stream().map(elem -> this.type.convert(elem, errorRecorder)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    @NotNull
    public Object toExportValue(@NotNull List<T> value) {
        return value.stream().map(this.type::toExportValue).collect(Collectors.toList());
    }
}

