/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.handlers.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import net.skinsrestorer.shadow.injector.exceptions.InjectorException;
import net.skinsrestorer.shadow.injector.handlers.instantiation.DirectInstantiationProvider;
import net.skinsrestorer.shadow.injector.handlers.instantiation.Resolution;
import net.skinsrestorer.shadow.injector.handlers.instantiation.StandardInjection;
import net.skinsrestorer.shadow.injector.utils.ReflectionUtils;
import net.skinsrestorer.shadow.javax.annotation.Nullable;
import net.skinsrestorer.shadow.javax.inject.Inject;

public class StandardInjectionProvider
extends DirectInstantiationProvider {
    @Override
    public <T> Resolution<T> safeGet(Class<T> clazz) {
        Constructor<T> constructor = this.getInjectionConstructor(clazz);
        if (constructor == null) {
            return null;
        }
        List<Field> fields = this.getFieldsToInject(clazz);
        this.validateInjection(clazz, constructor, fields);
        return new StandardInjection<T>(constructor, fields);
    }

    @Nullable
    protected <T> Constructor<T> getInjectionConstructor(Class<T> clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors.length == 1 && StandardInjectionProvider.isSuitableNoArgsConstructor(constructors[0])) {
            return constructors[0];
        }
        Constructor<?> matchingConstructor = null;
        for (Constructor<?> constructor : constructors) {
            if (!constructor.isAnnotationPresent(Inject.class)) continue;
            if (matchingConstructor != null) {
                throw new InjectorException("Class '" + clazz + "' may not have multiple @Inject constructors");
            }
            matchingConstructor = constructor;
        }
        if (matchingConstructor == null) {
            return StandardInjectionProvider.getNoArgsConstructorIfHasInjectField(clazz);
        }
        return matchingConstructor;
    }

    private static boolean isSuitableNoArgsConstructor(Constructor<?> c) {
        if (c.getParameterTypes().length > 0) {
            return false;
        }
        return !Modifier.isPrivate(c.getModifiers()) || Modifier.isPrivate(c.getDeclaringClass().getModifiers());
    }

    @Nullable
    private static <T> Constructor<T> getNoArgsConstructorIfHasInjectField(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            for (Field field : ReflectionUtils.safeGetDeclaredFields(clazz)) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                return constructor;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    protected List<Field> getFieldsToInject(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field f : ReflectionUtils.safeGetDeclaredFields(currentClass)) {
                if (!f.isAnnotationPresent(Inject.class)) continue;
                fields.add(f);
            }
        }
        return fields;
    }

    protected void validateInjection(Class<?> clazz, Constructor<?> constructor, List<Field> fields) {
        this.validateHasNoFinalFields(fields);
        this.validateHasNoInjectMethods(clazz);
    }

    private void validateHasNoFinalFields(List<Field> fields) {
        for (Field field : fields) {
            if (!Modifier.isFinal(field.getModifiers())) continue;
            throw new InjectorException("Field '" + field + "' may not be final and have @Inject");
        }
    }

    private void validateHasNoInjectMethods(Class<?> clazz) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Method m : ReflectionUtils.safeGetDeclaredMethods(currentClass)) {
                if (!m.isAnnotationPresent(Inject.class)) continue;
                throw new InjectorException("@Inject on methods is not supported, but found it on '" + m + "' while trying to instantiate '" + currentClass + "'");
            }
        }
    }
}

