/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.column;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;
import net.skinsrestorer.shadow.mariadb.message.server.ColumnDefinitionPacket;

public class DoubleColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public DoubleColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected DoubleColumn(DoubleColumn prev) {
        super(prev, true);
    }

    @Override
    public DoubleColumn useAliasAsName() {
        return new DoubleColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Double.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 8;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (this.isSigned()) {
            return "DOUBLE";
        }
        return "DOUBLE UNSIGNED";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length.get()));
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readDouble();
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String s = buf.readAscii(length.get());
        return !"0".equals(s);
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return (int)buf.readDouble() != 0;
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result;
        String str = buf.readString(length.get());
        try {
            result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).byteValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str, this.dataType}));
        }
        if ((long)((byte)result) != result || result < 0L && !this.isSigned()) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = (long)buf.readDouble();
        if ((long)((byte)result) != result) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return String.valueOf(buf.readDouble());
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result;
        String str = buf.readString(length.get());
        try {
            result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Short", str));
        }
        if ((long)((short)result) != result || result < 0L && !this.isSigned()) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = (long)buf.readDouble();
        if ((long)((short)result) != result || result < 0L && !this.isSigned()) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result;
        String str = buf.readString(length.get());
        try {
            result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", str));
        }
        int res = (int)result;
        if ((long)res != result || result < 0L && !this.isSigned()) {
            throw new SQLDataException("integer overflow");
        }
        return res;
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = (long)buf.readDouble();
        int res = (int)result;
        if ((long)res != result) {
            throw new SQLDataException("integer overflow");
        }
        return res;
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String str2 = buf.readAscii(length.get());
        try {
            return new BigDecimal(str2).setScale(0, RoundingMode.DOWN).longValueExact();
        }
        catch (ArithmeticException | NumberFormatException nfe) {
            throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", str2));
        }
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return (long)buf.readDouble();
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Float.parseFloat(buf.readAscii(length.get()));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return (float)buf.readDouble();
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length.get()));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readDouble();
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

