/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.result;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import net.skinsrestorer.shadow.mariadb.Statement;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.result.Result;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;

public class StreamingResult
extends Result {
    private static final int MAX_FETCH_SIZE = 16384;
    private final ReentrantLock lock;
    private int dataFetchTime;
    private int requestedFetchSize;

    public StreamingResult(Statement stmt, boolean binaryProtocol, long maxRows, ColumnDecoder[] metadataList, Reader reader, Context context, int fetchSize, ReentrantLock lock, int resultSetType, boolean closeOnCompletion, boolean traceEnable) throws SQLException {
        super(stmt, binaryProtocol, maxRows, metadataList, reader, context, resultSetType, closeOnCompletion, traceEnable, false, fetchSize);
        this.lock = lock;
        this.dataFetchTime = 0;
        this.requestedFetchSize = fetchSize;
        this.data = new byte[Math.min(16384, Math.max(fetchSize, 10))][];
        this.addStreamingValue();
    }

    @Override
    public boolean streaming() {
        return true;
    }

    private void nextStreamingValue() throws SQLException {
        if (this.resultSetType == 1003) {
            this.rowPointer = 0;
            this.dataSize = 0;
        }
        this.addStreamingValue();
    }

    private void addStreamingValue() throws SQLException {
        this.lock.lock();
        try {
            int fetchSizeTmp = this.maxRows <= 0L ? super.getFetchSize() : Math.min(super.getFetchSize(), Math.max(0, (int)(this.maxRows - (long)(this.dataFetchTime * super.getFetchSize()))));
            do {
                byte[] buf = this.reader.readPacket(this.traceEnable);
                this.readNext(buf);
            } while (--fetchSizeTmp > 0 && !this.loaded);
            ++this.dataFetchTime;
            if (this.maxRows > 0L && (long)this.dataFetchTime * (long)super.getFetchSize() >= this.maxRows && !this.loaded) {
                this.skipRemaining();
            }
        }
        catch (IOException ioe) {
            throw this.exceptionFactory.create("Error while streaming resultSet data", "08000", ioe);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void fetchRemaining() throws SQLException {
        if (!this.loaded) {
            while (!this.loaded) {
                this.addStreamingValue();
            }
            ++this.dataFetchTime;
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize - 1) {
            ++this.rowPointer;
            this.setRow(this.data[this.rowPointer]);
            return true;
        }
        if (!this.loaded) {
            this.lock.lock();
            try {
                if (!this.loaded) {
                    this.nextStreamingValue();
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.resultSetType == 1003) {
                this.rowPointer = 0;
                if (this.dataSize > 0) {
                    this.setRow(this.data[this.rowPointer]);
                    return true;
                }
            } else {
                ++this.rowPointer;
                if (this.dataSize > this.rowPointer) {
                    this.setRow(this.data[this.rowPointer]);
                    return true;
                }
            }
            this.setNullRowBuf();
            return false;
        }
        this.rowPointer = this.dataSize;
        this.setNullRowBuf();
        return false;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize) {
            return false;
        }
        return this.dataSize > 0 || this.dataFetchTime > 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            return this.rowPointer == 0 && this.dataSize > 0 && this.dataFetchTime == 1;
        }
        return this.rowPointer == 0 && this.dataSize > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize - 1) {
            return false;
        }
        if (this.loaded) {
            return this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
        }
        this.addStreamingValue();
        if (this.loaded) {
            return this.rowPointer == this.dataSize - 1;
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        this.checkNotForwardOnly();
        this.setNullRowBuf();
        this.rowPointer = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        this.checkNotForwardOnly();
        this.fetchRemaining();
        this.setNullRowBuf();
        this.rowPointer = this.dataSize;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        this.checkNotForwardOnly();
        this.rowPointer = 0;
        if (this.dataSize > 0) {
            this.setRow(this.data[this.rowPointer]);
            return true;
        }
        this.setNullRowBuf();
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        this.fetchRemaining();
        this.rowPointer = this.dataSize - 1;
        if (this.dataSize > 0) {
            this.setRow(this.data[this.rowPointer]);
            return true;
        }
        this.setNullRowBuf();
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (this.resultSetType == 1003) {
            return 0;
        }
        return this.rowPointer + 1;
    }

    @Override
    public boolean absolute(int idx) throws SQLException {
        this.checkClose();
        this.checkNotForwardOnly();
        if (idx == 0) {
            this.rowPointer = -1;
            this.setNullRowBuf();
            return false;
        }
        if (idx > 0 && idx <= this.dataSize) {
            this.rowPointer = idx - 1;
            this.setRow(this.data[this.rowPointer]);
            return true;
        }
        this.fetchRemaining();
        if (idx > 0) {
            if (idx <= this.dataSize) {
                this.rowPointer = idx - 1;
                this.setRow(this.data[this.rowPointer]);
                return true;
            }
            this.rowPointer = this.dataSize;
            this.setNullRowBuf();
        } else {
            if (this.dataSize + idx >= 0) {
                this.rowPointer = this.dataSize + idx;
                this.setRow(this.data[this.rowPointer]);
                return true;
            }
            this.setNullRowBuf();
            this.rowPointer = -1;
        }
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        int newPos = this.rowPointer + rows;
        if (newPos <= -1) {
            this.checkNotForwardOnly();
            this.rowPointer = -1;
            this.setNullRowBuf();
            return false;
        }
        while (newPos >= this.dataSize) {
            if (this.loaded) {
                this.rowPointer = this.dataSize;
                this.setNullRowBuf();
                return false;
            }
            this.addStreamingValue();
        }
        this.rowPointer = newPos;
        this.setRow(this.data[this.rowPointer]);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        this.checkNotForwardOnly();
        if (this.rowPointer > -1) {
            --this.rowPointer;
            if (this.rowPointer != -1) {
                this.setRow(this.data[this.rowPointer]);
                return true;
            }
        }
        this.setNullRowBuf();
        return false;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClose();
        return this.requestedFetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        super.setFetchSize(Math.min(16384, fetchSize));
        this.requestedFetchSize = fetchSize;
        this.checkClose();
        if (fetchSize == 0) {
            while (!this.loaded) {
                this.addStreamingValue();
            }
        }
    }
}

