/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.EnumSet;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;
import net.skinsrestorer.shadow.mariadb.plugin.Codec;
import net.skinsrestorer.shadow.mariadb.plugin.codec.LocalDateTimeCodec;

public class InstantCodec
implements Codec<Instant> {
    public static final InstantCodec INSTANCE = new InstantCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATETIME, new DataType[]{DataType.DATE, DataType.YEAR, DataType.TIMESTAMP, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.TIME, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Instant.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Instant.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Instant;
    }

    @Override
    public Instant decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar calParam) throws SQLDataException {
        LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeText(buf, length, column, calParam);
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    @Override
    public Instant decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar calParam) throws SQLDataException {
        LocalDateTime localDateTime = LocalDateTimeCodec.INSTANCE.decodeBinary(buf, length, column, calParam);
        if (localDateTime == null) {
            return null;
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar calParam, Long maxLen) throws IOException {
        Instant instant = (Instant)val;
        encoder.writeByte(39);
        if (calParam == null && "UTC".equals(ZoneId.systemDefault().getId())) {
            encoder.writeAscii(instant.toString().replace('T', ' '));
            encoder.pos(encoder.pos() - 1);
        } else {
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
            if (calParam != null) {
                zonedDateTime = zonedDateTime.withZoneSameInstant(calParam.getTimeZone().toZoneId());
            }
            encoder.writeAscii(zonedDateTime.format(instant.getNano() != 0 ? LocalDateTimeCodec.TIMESTAMP_FORMAT : LocalDateTimeCodec.TIMESTAMP_FORMAT_NO_FRACTIONAL));
        }
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar calParam, Long maxLength) throws IOException {
        int nano;
        Instant instant = (Instant)value;
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        if (calParam != null) {
            zonedDateTime = zonedDateTime.withZoneSameInstant(calParam.getTimeZone().toZoneId());
        }
        if ((nano = zonedDateTime.getNano()) > 0) {
            encoder.writeByte(11);
            encoder.writeShort((short)zonedDateTime.getYear());
            encoder.writeByte(zonedDateTime.getMonth().getValue());
            encoder.writeByte(zonedDateTime.getDayOfMonth());
            encoder.writeByte(zonedDateTime.getHour());
            encoder.writeByte(zonedDateTime.getMinute());
            encoder.writeByte(zonedDateTime.getSecond());
            encoder.writeInt(nano / 1000);
        } else {
            encoder.writeByte(7);
            encoder.writeShort((short)zonedDateTime.getYear());
            encoder.writeByte(zonedDateTime.getMonthValue());
            encoder.writeByte(zonedDateTime.getDayOfMonth());
            encoder.writeByte(zonedDateTime.getHour());
            encoder.writeByte(zonedDateTime.getMinute());
            encoder.writeByte(zonedDateTime.getSecond());
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }
}

