/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.xseries;

import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import net.skinsrestorer.shadow.javax.annotation.Nonnull;
import net.skinsrestorer.shadow.javax.annotation.Nullable;
import net.skinsrestorer.shadow.xseries.ReflectionUtils;
import net.skinsrestorer.shadow.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullUtils {
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_GETTER;
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_SETTER;
    protected static final MethodHandle CRAFT_META_SKULL_BLOCK_SETTER;
    protected static final MethodHandle PROPERTY_GETVALUE;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final boolean SUPPORTS_UUID;
    private static final String INVALID_BASE64 = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzEwNTkxZTY5MDllNmEyODFiMzcxODM2ZTQ2MmQ2N2EyYzc4ZmEwOTUyZTkxMGYzMmI0MWEyNmM0OGMxNzU3YyJ9fX0=";
    private static final Pattern MOJANG_SHA256_APPROX;
    private static final AtomicLong MOJANG_SHA_FAKE_ID_ENUMERATOR;
    private static final Map<String, GameProfile> MOJANG_SHA_FAKE_PROFILES;
    private static final boolean NULLABILITY_RECORD_UPDATE;
    private static final UUID IDENTITY_UUID;
    private static final UUID GAME_PROFILE_EMPTY_UUID;
    private static final String GAME_PROFILE_EMPTY_NAME;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";

    @Nonnull
    public static ItemStack getSkull(@Nonnull UUID id) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        } else {
            meta.setOwner(Bukkit.getOfflinePlayer((UUID)id).getName());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull OfflinePlayer identifier) {
        SkullMeta meta = (SkullMeta)head;
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(identifier);
        } else {
            meta.setOwner(identifier.getName());
        }
        return meta;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull UUID identifier) {
        return SkullUtils.applySkin(head, Bukkit.getOfflinePlayer((UUID)identifier));
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta head, @Nonnull String identifier) {
        SkullMeta meta = (SkullMeta)head;
        StringSkullCache result = SkullUtils.detectSkullValueType(identifier);
        switch (result.valueType) {
            case UUID: {
                return SkullUtils.applySkin(head, Bukkit.getOfflinePlayer((UUID)((UUID)result.object)));
            }
            case NAME: {
                return SkullUtils.applySkin(head, Bukkit.getOfflinePlayer((String)identifier));
            }
            case BASE64: {
                return SkullUtils.setSkullBase64(meta, identifier, SkullUtils.extractMojangSHAFromBase64((String)result.object));
            }
            case TEXTURE_URL: {
                return SkullUtils.setSkullBase64(meta, SkullUtils.encodeTexturesURL(identifier), SkullUtils.extractMojangSHAFromBase64(identifier));
            }
            case TEXTURE_HASH: {
                return SkullUtils.setSkullBase64(meta, SkullUtils.encodeTexturesURL(TEXTURES + identifier), identifier);
            }
            case UNKNOWN: {
                return SkullUtils.setSkullBase64(meta, INVALID_BASE64, INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    @Nonnull
    public static SkullMeta setSkullBase64(@Nonnull SkullMeta head, @Nonnull String value, String MojangSHA) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Skull value cannot be null or empty");
        }
        GameProfile profile = SkullUtils.profileFromBase64(value, MojangSHA);
        try {
            CRAFT_META_SKULL_PROFILE_SETTER.invoke(head, profile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return head;
    }

    @Nonnull
    public static GameProfile profileFromBase64(String base64, String MojangSHA) {
        GameProfile gp = MOJANG_SHA_FAKE_PROFILES.get(MojangSHA);
        if (gp != null) {
            return gp;
        }
        gp = new GameProfile(NULLABILITY_RECORD_UPDATE ? GAME_PROFILE_EMPTY_UUID : new UUID(MOJANG_SHA_FAKE_ID_ENUMERATOR.getAndIncrement(), 0L), GAME_PROFILE_EMPTY_NAME);
        gp.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        MOJANG_SHA_FAKE_PROFILES.put(MojangSHA, gp);
        return gp;
    }

    @Nonnull
    public static GameProfile profileFromPlayer(OfflinePlayer player) {
        return new GameProfile(player.getUniqueId(), player.getName());
    }

    @Nonnull
    public static GameProfile detectProfileFromString(String identifier) {
        StringSkullCache result = SkullUtils.detectSkullValueType(identifier);
        switch (result.valueType) {
            case UUID: {
                return new GameProfile((UUID)result.object, GAME_PROFILE_EMPTY_NAME);
            }
            case NAME: {
                return new GameProfile(GAME_PROFILE_EMPTY_UUID, identifier);
            }
            case BASE64: {
                return SkullUtils.profileFromBase64(identifier, SkullUtils.extractMojangSHAFromBase64((String)result.object));
            }
            case TEXTURE_URL: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(identifier), SkullUtils.extractMojangSHAFromBase64(identifier));
            }
            case TEXTURE_HASH: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(TEXTURES + identifier), identifier);
            }
            case UNKNOWN: {
                return SkullUtils.profileFromBase64(INVALID_BASE64, INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    @Nonnull
    public static StringSkullCache detectSkullValueType(@Nonnull String identifier) {
        try {
            UUID id = UUID.fromString(identifier);
            return new StringSkullCache(ValueType.UUID, id);
        }
        catch (IllegalArgumentException id) {
            byte[] decoded;
            if (SkullUtils.isUsername(identifier)) {
                return new StringSkullCache(ValueType.NAME);
            }
            if (identifier.contains("textures.minecraft.net")) {
                return new StringSkullCache(ValueType.TEXTURE_URL);
            }
            if (identifier.length() > 100 && (decoded = SkullUtils.isBase64(identifier)) != null) {
                return new StringSkullCache(ValueType.BASE64, new String(decoded));
            }
            if (MOJANG_SHA256_APPROX.matcher(identifier).matches()) {
                return new StringSkullCache(ValueType.TEXTURE_HASH);
            }
            return new StringSkullCache(ValueType.UNKNOWN);
        }
    }

    public static void setSkin(@Nonnull Block block, @Nonnull String value) {
        Objects.requireNonNull(block, "Can't set skin of null block");
        BlockState state = block.getState();
        if (!(state instanceof Skull)) {
            return;
        }
        Skull skull = (Skull)state;
        GameProfile profile = SkullUtils.detectProfileFromString(value);
        try {
            CRAFT_META_SKULL_BLOCK_SETTER.invoke(skull, profile);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while setting block skin with value: " + value, e);
        }
        skull.update(true);
    }

    public static String encodeTexturesURL(String url) {
        return SkullUtils.encodeBase64(VALUE_PROPERTY + url + "\"}}}");
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    private static byte[] isBase64(@Nonnull String base64) {
        try {
            return Base64.getDecoder().decode(base64);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public static String getSkinValue(@Nonnull ItemMeta skull) {
        Objects.requireNonNull(skull, "Skull ItemStack cannot be null");
        SkullMeta meta = (SkullMeta)skull;
        GameProfile profile = null;
        try {
            profile = CRAFT_META_SKULL_PROFILE_GETTER.invoke(meta);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                String value = SkullUtils.getPropertyValue(property);
                if (value.isEmpty()) continue;
                return value;
            }
        }
        return null;
    }

    private static String getPropertyValue(Property property) {
        if (NULLABILITY_RECORD_UPDATE) {
            return property.value();
        }
        try {
            return PROPERTY_GETVALUE.invoke(property);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractMojangSHAFromBase64(String decodedBase64) {
        int startIndex = decodedBase64.lastIndexOf(47);
        int endIndex = decodedBase64.lastIndexOf(34);
        if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex) {
            throw new IllegalArgumentException("Invalid Base64 skull value: " + decodedBase64);
        }
        try {
            return decodedBase64.substring(startIndex + 1, endIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Invalid Base64 skull value: " + decodedBase64, ex);
        }
    }

    private static boolean isUsername(@Nonnull String name) {
        int len = name.length();
        if (len > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)name).iterator();
        while (unmodifiableIterator.hasNext()) {
            char ch = ((Character)unmodifiableIterator.next()).charValue();
            if (ch == '_' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        SUPPORTS_UUID = ReflectionUtils.supports(12);
        MOJANG_SHA256_APPROX = Pattern.compile("[0-9a-z]{60,70}");
        MOJANG_SHA_FAKE_ID_ENUMERATOR = new AtomicLong(1L);
        MOJANG_SHA_FAKE_PROFILES = new HashMap<String, GameProfile>();
        NULLABILITY_RECORD_UPDATE = ReflectionUtils.supports(20, 2);
        IDENTITY_UUID = new UUID(0L, 0L);
        GAME_PROFILE_EMPTY_UUID = NULLABILITY_RECORD_UPDATE ? IDENTITY_UUID : null;
        GAME_PROFILE_EMPTY_NAME = NULLABILITY_RECORD_UPDATE ? "" : null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle profileSetter = null;
        MethodHandle profileGetter = null;
        MethodHandle blockSetter = null;
        MethodHandle propGetval = null;
        try {
            Class<?> CraftMetaSkull = ReflectionUtils.getCraftClass("inventory.CraftMetaSkull");
            Field profile = CraftMetaSkull.getDeclaredField("profile");
            profile.setAccessible(true);
            profileGetter = lookup.unreflectGetter(profile);
            try {
                Method setProfile = CraftMetaSkull.getDeclaredMethod("setProfile", GameProfile.class);
                setProfile.setAccessible(true);
                profileSetter = lookup.unreflect(setProfile);
            }
            catch (NoSuchMethodException e) {
                profileSetter = lookup.unreflectSetter(profile);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Class<?> CraftSkullBlock = ReflectionUtils.getCraftClass("block.CraftSkull");
            Field field = CraftSkullBlock.getDeclaredField("profile");
            field.setAccessible(true);
            blockSetter = lookup.unreflectSetter(field);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!ReflectionUtils.supports(20, 2)) {
            try {
                propGetval = lookup.findVirtual(Property.class, "getValue", MethodType.methodType(String.class));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        PROPERTY_GETVALUE = propGetval;
        CRAFT_META_SKULL_PROFILE_SETTER = profileSetter;
        CRAFT_META_SKULL_PROFILE_GETTER = profileGetter;
        CRAFT_META_SKULL_BLOCK_SETTER = blockSetter;
    }

    private static final class StringSkullCache {
        private final ValueType valueType;
        private final Object object;

        private StringSkullCache(ValueType valueType) {
            this(valueType, (Object)null);
        }

        private StringSkullCache(ValueType valueType, Object object) {
            this.valueType = valueType;
            this.object = object;
        }
    }

    public static enum ValueType {
        NAME,
        UUID,
        BASE64,
        TEXTURE_URL,
        TEXTURE_HASH,
        UNKNOWN;

    }
}

