/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.api;

import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.connections.MineSkinAPI;
import net.skinsrestorer.api.connections.MojangAPI;
import net.skinsrestorer.api.event.EventBus;
import net.skinsrestorer.api.property.SkinApplier;
import net.skinsrestorer.api.storage.CacheStorage;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.api.event.EventBusImpl;

public class SharedSkinsRestorer
implements SkinsRestorer {
    private final SkinStorage skinStorage;
    private final PlayerStorage playerStorage;
    private final CacheStorage cacheStorage;
    private final MojangAPI mojangAPI;
    private final MineSkinAPI mineSkinAPI;
    private final SharedSkinApplier<?> skinApplier;
    private final EventBusImpl eventBus;

    @Override
    public <P> SkinApplier<P> getSkinApplier(Class<P> playerClass) {
        if (!this.skinApplier.accepts(playerClass)) {
            throw new IllegalArgumentException("Unsupported player class: " + playerClass.getName());
        }
        return this.skinApplier;
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public String getVersion() {
        return "15.0.4";
    }

    @Override
    public String getCommit() {
        return "677e9677";
    }

    @Override
    public String getCommitShort() {
        return BuildData.COMMIT_SHORT;
    }

    @Inject
    public SharedSkinsRestorer(SkinStorage skinStorage, PlayerStorage playerStorage, CacheStorage cacheStorage, MojangAPI mojangAPI, MineSkinAPI mineSkinAPI, SharedSkinApplier<?> skinApplier, EventBusImpl eventBus) {
        this.skinStorage = skinStorage;
        this.playerStorage = playerStorage;
        this.cacheStorage = cacheStorage;
        this.mojangAPI = mojangAPI;
        this.mineSkinAPI = mineSkinAPI;
        this.skinApplier = skinApplier;
        this.eventBus = eventBus;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    @Override
    public PlayerStorage getPlayerStorage() {
        return this.playerStorage;
    }

    @Override
    public CacheStorage getCacheStorage() {
        return this.cacheStorage;
    }

    @Override
    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    @Override
    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }
}

