/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.gui;

import java.util.function.Consumer;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.commands.library.CommandManager;
import net.skinsrestorer.shared.gui.GUIManager;
import net.skinsrestorer.shared.listeners.event.ClickEventInfo;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRServerPlayer;

public class SharedGUI {
    public static final int HEAD_COUNT_PER_PAGE = 36;
    private final SkinStorageImpl skinStorage;

    public <T> T createGUI(GUIManager<T> manager, Consumer<ClickEventInfo> callback, SRForeign player, int page) {
        if (page > 999) {
            page = 999;
        }
        int skinNumber = 36 * page;
        return manager.createGUI(callback, player, page, this.skinStorage.getGUISkins(skinNumber));
    }

    @Inject
    public SharedGUI(SkinStorageImpl skinStorage) {
        this.skinStorage = skinStorage;
    }

    public static class ProxyGUIActions
    implements Consumer<ClickEventInfo> {
        private final SRServerAdapter<?> adapter;

        @Override
        public void accept(ClickEventInfo event) {
            SRServerPlayer player = event.getPlayer();
            switch (event.getMaterial()) {
                case HEAD: {
                    String skinName = event.getDisplayName();
                    this.adapter.runAsync(() -> this.adapter.sendToMessageChannel(event.getPlayer(), out -> {
                        out.writeUTF("setSkin");
                        out.writeUTF(player.getName());
                        out.writeUTF(skinName);
                    }));
                    player.closeInventory();
                    break;
                }
                case RED_PANE: {
                    this.adapter.runAsync(() -> this.adapter.sendToMessageChannel(event.getPlayer(), out -> {
                        out.writeUTF("clearSkin");
                        out.writeUTF(player.getName());
                    }));
                    player.closeInventory();
                    break;
                }
                case GREEN_PANE: {
                    this.adapter.runAsync(() -> this.adapter.requestSkinsFromProxy(event.getPlayer(), event.getCurrentPage() + 1));
                    break;
                }
                case YELLOW_PANE: {
                    this.adapter.runAsync(() -> this.adapter.requestSkinsFromProxy(event.getPlayer(), event.getCurrentPage() - 1));
                    break;
                }
            }
        }

        @Inject
        public ProxyGUIActions(SRServerAdapter<?> adapter) {
            this.adapter = adapter;
        }
    }

    public static class ServerGUIActions
    implements Consumer<ClickEventInfo> {
        private final SRServerAdapter<?> adapter;
        private final CommandManager<SRCommandSender> commandManager;

        @Override
        public void accept(ClickEventInfo event) {
            SRServerPlayer player = event.getPlayer();
            switch (event.getMaterial()) {
                case HEAD: {
                    this.commandManager.executeCommand(player, "skin set " + event.getDisplayName());
                    player.closeInventory();
                    break;
                }
                case RED_PANE: {
                    this.commandManager.executeCommand(player, "skin clear");
                    player.closeInventory();
                    break;
                }
                case GREEN_PANE: {
                    this.adapter.runAsync(() -> this.adapter.openServerGUI(player, event.getCurrentPage() + 1));
                    break;
                }
                case YELLOW_PANE: {
                    this.adapter.runAsync(() -> this.adapter.openServerGUI(player, event.getCurrentPage() - 1));
                    break;
                }
            }
        }

        @Inject
        public ServerGUIActions(SRServerAdapter<?> adapter, CommandManager<SRCommandSender> commandManager) {
            this.adapter = adapter;
            this.commandManager = commandManager;
        }
    }
}

