/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.api.SharedSkinApplier;
import net.skinsrestorer.shared.listeners.event.SRServerMessageEvent;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.MessageProtocolUtil;

public final class SRServerMessageAdapter {
    private final SRServerAdapter<?> plugin;
    private final SharedSkinApplier<Object> skinApplier;

    public void handlePluginMessage(SRServerMessageEvent event) {
        if (!event.getChannel().equals("sr:messagechannel")) {
            return;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(event.getData()));
        try {
            String subChannel = in.readUTF();
            if (subChannel.equalsIgnoreCase("returnSkinsV3")) {
                Optional<SRPlayer> player = this.plugin.getPlayer(in.readUTF());
                if (!player.isPresent()) {
                    return;
                }
                int page = in.readInt();
                short len = in.readShort();
                byte[] msgBytes = new byte[len];
                in.readFully(msgBytes);
                Map<String, String> skinList = MessageProtocolUtil.convertToMap(msgBytes);
                this.plugin.openProxyGUI(player.get(), page, skinList);
            } else if (subChannel.equalsIgnoreCase("SkinUpdateV2")) {
                this.skinApplier.applySkin(event.getPlayer().getAs(Object.class), SkinProperty.of(in.readUTF(), in.readUTF()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Inject
    public SRServerMessageAdapter(SRServerAdapter<?> plugin, SharedSkinApplier<Object> skinApplier) {
        this.plugin = plugin;
        this.skinApplier = skinApplier;
    }
}

