/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.log;

import java.util.ArrayList;

public class AnsiBuilder
implements Appendable {
    private static final char FIRST_ESC_CHAR = '\u001b';
    private static final char SECOND_ESC_CHAR = '[';
    private final StringBuilder builder;
    private final ArrayList<Integer> attributeOptions = new ArrayList(5);

    public AnsiBuilder() {
        this(new StringBuilder(80));
    }

    public AnsiBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    public static AnsiBuilder ansi() {
        return new AnsiBuilder();
    }

    public AnsiBuilder fg(Color color) {
        this.attributeOptions.add(color.fg());
        return this;
    }

    public AnsiBuilder a(Attribute attribute) {
        this.attributeOptions.add(attribute.value());
        return this;
    }

    public AnsiBuilder bold() {
        return this.a(Attribute.INTENSITY_BOLD);
    }

    public AnsiBuilder boldOff() {
        return this.a(Attribute.INTENSITY_BOLD_OFF);
    }

    public String toString() {
        this.flushAttributes();
        return this.builder.toString();
    }

    private void flushAttributes() {
        if (this.attributeOptions.isEmpty()) {
            return;
        }
        if (this.attributeOptions.size() == 1 && this.attributeOptions.get(0) == 0) {
            this.builder.append('\u001b');
            this.builder.append('[');
            this.builder.append('m');
        } else {
            this._appendEscapeSequence(this.attributeOptions.toArray());
        }
        this.attributeOptions.clear();
    }

    private void _appendEscapeSequence(Object ... options) {
        this.builder.append('\u001b');
        this.builder.append('[');
        int size = options.length;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.builder.append(';');
            }
            if (options[i] == null) continue;
            this.builder.append(options[i]);
        }
        this.builder.append('m');
    }

    @Override
    public AnsiBuilder append(CharSequence csq) {
        this.builder.append(csq);
        return this;
    }

    @Override
    public AnsiBuilder append(CharSequence csq, int start, int end) {
        this.builder.append(csq, start, end);
        return this;
    }

    @Override
    public AnsiBuilder append(char c) {
        this.builder.append(c);
        return this;
    }

    public static enum Color {
        BLACK(0, "BLACK"),
        RED(1, "RED"),
        GREEN(2, "GREEN"),
        YELLOW(3, "YELLOW"),
        BLUE(4, "BLUE"),
        MAGENTA(5, "MAGENTA"),
        CYAN(6, "CYAN"),
        WHITE(7, "WHITE"),
        DEFAULT(9, "DEFAULT");

        private final int value;
        private final String name;

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        public int fg() {
            return this.value + 30;
        }

        private Color(int value, String name) {
            this.value = value;
            this.name = name;
        }
    }

    public static enum Attribute {
        RESET(0, "RESET"),
        INTENSITY_BOLD(1, "INTENSITY_BOLD"),
        INTENSITY_FAINT(2, "INTENSITY_FAINT"),
        ITALIC(3, "ITALIC_ON"),
        UNDERLINE(4, "UNDERLINE_ON"),
        BLINK_SLOW(5, "BLINK_SLOW"),
        BLINK_FAST(6, "BLINK_FAST"),
        NEGATIVE_ON(7, "NEGATIVE_ON"),
        CONCEAL_ON(8, "CONCEAL_ON"),
        STRIKETHROUGH_ON(9, "STRIKETHROUGH_ON"),
        UNDERLINE_DOUBLE(21, "UNDERLINE_DOUBLE"),
        INTENSITY_BOLD_OFF(22, "INTENSITY_BOLD_OFF"),
        ITALIC_OFF(23, "ITALIC_OFF"),
        UNDERLINE_OFF(24, "UNDERLINE_OFF"),
        BLINK_OFF(25, "BLINK_OFF"),
        NEGATIVE_OFF(27, "NEGATIVE_OFF"),
        CONCEAL_OFF(28, "CONCEAL_OFF"),
        STRIKETHROUGH_OFF(29, "STRIKETHROUGH_OFF");

        private final int value;
        private final String name;

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        private Attribute(int value, String name) {
            this.value = value;
            this.name = name;
        }
    }
}

