/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.utils.IOExceptionConsumer;

public interface SRServerAdapter<P>
extends SRPlatformAdapter<P> {
    public void runSync(Runnable var1);

    public void runSyncToPlayer(SRPlayer var1, Runnable var2);

    public boolean determineProxy();

    public void openServerGUI(SRPlayer var1, int var2);

    public void openProxyGUI(SRPlayer var1, int var2, Map<String, String> var3);

    public Optional<SRPlayer> getPlayer(String var1);

    default public void requestSkinsFromProxy(SRPlayer player, int page) {
        this.sendToMessageChannel(player, out -> {
            out.writeUTF("getSkins");
            out.writeUTF(player.getName());
            out.writeInt(page);
        });
    }

    default public void sendToMessageChannel(SRPlayer player, IOExceptionConsumer<DataOutputStream> consumer) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            consumer.accept(out);
            this.sendMessageToChannel(player, bytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendMessageToChannel(SRPlayer var1, byte[] var2);
}

