/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.storage.CacheStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.connections.MojangAPIImpl;
import net.skinsrestorer.shared.exception.DataRequestExceptionShared;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.model.cache.MojangCacheData;
import net.skinsrestorer.shared.utils.TimeUtil;
import net.skinsrestorer.shared.utils.ValidationUtil;

public class CacheStorageImpl
implements CacheStorage {
    private final SRLogger logger;
    private final MojangAPIImpl mojangAPI;
    private final SettingsManager settings;
    private final AdapterReference adapterReference;
    private final Injector injector;

    @Override
    public Optional<MojangSkinDataResult> getSkin(String playerName, boolean allowExpired) throws DataRequestException {
        return this.injector.getSingleton(SkinStorage.class).getPlayerSkin(playerName, allowExpired);
    }

    @Override
    public Optional<UUID> getUUID(String playerName, boolean allowExpired) throws DataRequestException {
        if (ValidationUtil.invalidMojangUsername(playerName)) {
            return Optional.empty();
        }
        try {
            Optional<MojangCacheData> stored = this.getCachedData(playerName, allowExpired);
            if (stored.isPresent()) {
                return stored.get().getUniqueId();
            }
            try {
                Optional<UUID> uuid = this.mojangAPI.getUUID(playerName);
                this.adapterReference.get().setCachedUUID(playerName, MojangCacheData.of(uuid.orElse(null), TimeUtil.getEpochSecond()));
                return uuid;
            }
            catch (DataRequestException e) {
                this.logger.debug("Failed to get UUID from Mojang for " + playerName, e);
                throw new DataRequestExceptionShared(e);
            }
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.warning("Failed to get UUID from cache for " + playerName, e);
            return Optional.empty();
        }
    }

    public Optional<MojangCacheData> getCachedData(String playerName, boolean allowExpired) throws StorageAdapter.StorageException {
        Optional<MojangCacheData> optional = this.adapterReference.get().getCachedUUID(playerName);
        if (optional.isPresent() && (allowExpired || this.isValidUUIDTimestamp(optional.get().getTimestamp()))) {
            return optional;
        }
        return Optional.empty();
    }

    private boolean isValidUUIDTimestamp(long epochSecond) {
        int expiresAfter = this.settings.getProperty(StorageConfig.UUID_EXPIRES_AFTER);
        return expiresAfter <= 0 || TimeUtil.getEpochSecond() - epochSecond <= (long)expiresAfter;
    }

    @Inject
    public CacheStorageImpl(SRLogger logger, MojangAPIImpl mojangAPI, SettingsManager settings, AdapterReference adapterReference, Injector injector) {
        this.logger = logger;
        this.mojangAPI = mojangAPI;
        this.settings = settings;
        this.adapterReference = adapterReference;
        this.injector = injector;
    }
}

