/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.mysql;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.config.DatabaseConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.adapter.mysql.MySQLProvider;
import net.skinsrestorer.shared.storage.model.cache.MojangCacheData;
import net.skinsrestorer.shared.storage.model.player.LegacyPlayerData;
import net.skinsrestorer.shared.storage.model.player.PlayerData;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.storage.model.skin.LegacySkinData;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;
import net.skinsrestorer.shared.storage.model.skin.URLIndexData;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;

public class MySQLAdapter
implements StorageAdapter {
    private final MySQLProvider mysql;
    private final SettingsManager settings;
    private final SRLogger logger;
    private final SRPlugin plugin;

    @Override
    public void init() {
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolveCacheTable() + "` (`name` VARCHAR(16) NOT NULL,`uuid` VARCHAR(36),`timestamp` BIGINT(20) NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolvePlayerTable() + "` (`uuid` VARCHAR(36) NOT NULL,`skin_identifier` VARCHAR(2083),`skin_variant` VARCHAR(20),`skin_type` VARCHAR(20),PRIMARY KEY (`uuid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolvePlayerSkinTable() + "` (`uuid` VARCHAR(36) NOT NULL,`last_known_name` VARCHAR(16),`value` TEXT NOT NULL,`signature` TEXT NOT NULL,`timestamp` BIGINT(20) NOT NULL,PRIMARY KEY (`uuid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolveURLSkinTable() + "` (`url` VARCHAR(266) NOT NULL,`mine_skin_id` VARCHAR(36),`value` TEXT NOT NULL,`signature` TEXT NOT NULL,`skin_variant` VARCHAR(20),PRIMARY KEY (`url`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolveURLSkinIndexTable() + "` (`url` VARCHAR(266) NOT NULL,`skin_variant` VARCHAR(20),PRIMARY KEY (`url`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolveCustomSkinTable() + "` (`name` VARCHAR(36) NOT NULL,`value` TEXT NOT NULL,`signature` TEXT NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        try {
            this.migrateLegacyPlayerTable();
            this.migrateLegacySkinTable();
            this.migrateV15();
        }
        catch (IOException e) {
            this.logger.severe("Failed to migrate tables", e);
        }
    }

    private void migrateV15() {
        if (this.columnExists(this.resolveCacheTable(), "is_premium")) {
            this.mysql.execute("ALTER TABLE `" + this.resolveCacheTable() + "` DROP COLUMN `is_premium`", new Object[0]);
        }
    }

    private void migrateLegacyPlayerTable() throws IOException {
        Optional<String> legacyPlayerTable = this.getLegacyPlayerTableFile();
        if (!legacyPlayerTable.isPresent()) {
            return;
        }
        if (!this.tableExists(legacyPlayerTable.get())) {
            this.logger.info("Legacy player table to seems to no longer exist, this may be because it was already migrated! Skipping player table migration...");
            this.plugin.moveToArchive(this.getLegacyPlayerTableFilePath());
            return;
        }
        this.logger.info("Migrating legacy player table to new format...");
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolveLegacyPlayerTable() + "` (`name` varchar(17) NOT NULL,`skin_name` varchar(19) NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + legacyPlayerTable.get(), new Object[0]);){
            while (crs.next()) {
                String name = crs.getString("Nick");
                String skin = crs.getString("Skin");
                this.mysql.execute("INSERT INTO " + this.resolveLegacyPlayerTable() + " (name, skin_name) VALUES (?, ?)", name, skin);
            }
        }
        catch (SQLException e) {
            this.logger.severe("Failed to migrate legacy player table", e);
        }
        this.mysql.execute("DROP TABLE " + legacyPlayerTable.get(), new Object[0]);
        Files.deleteIfExists(this.getLegacyPlayerTableFilePath());
        this.logger.info("Player migration complete!");
    }

    private void migrateLegacySkinTable() throws IOException {
        Optional<String> legacySkinTable = this.getLegacySkinTableFile();
        if (!legacySkinTable.isPresent()) {
            return;
        }
        if (!this.tableExists(legacySkinTable.get())) {
            this.logger.info("Legacy skin table to seems to no longer exist, this may be because it was already migrated! Skipping skin table migration...");
            this.plugin.moveToArchive(this.getLegacySkinTableFilePath());
            return;
        }
        this.logger.info("Migrating legacy skin table to new format...");
        this.mysql.execute("CREATE TABLE IF NOT EXISTS `" + this.resolveLegacySkinTable() + "` (`name` varchar(36) NOT NULL,`value` text NOT NULL,`signature` text NOT NULL,PRIMARY KEY (`name`)) ENGINE=InnoDB DEFAULT CHARSET=utf8", new Object[0]);
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + legacySkinTable.get(), new Object[0]);){
            while (crs.next()) {
                String name = crs.getString("Nick");
                String value = crs.getString("Value");
                String signature = crs.getString("Signature");
                String timestampString = crs.getString("timestamp");
                if (timestampString == null || this.isLegacyCustomSkinTimestamp(Long.parseLong(timestampString))) {
                    this.setCustomSkinData(name, CustomSkinData.of(name, SkinProperty.of(value, signature)));
                    continue;
                }
                this.mysql.execute("INSERT INTO " + this.resolveLegacySkinTable() + " (name, value, signature) VALUES (?, ?, ?)", name, value, signature);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        this.mysql.execute("DROP TABLE `" + legacySkinTable.get() + "`", new Object[0]);
        Files.deleteIfExists(this.getLegacySkinTableFilePath());
        this.logger.info("Skin migration complete!");
    }

    private boolean tableExists(String table) {
        boolean bl;
        block8: {
            ResultSet rs = this.mysql.query("SHOW TABLES LIKE '" + table + "'", new Object[0]);
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.severe("Failed to check if table exists", e);
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    private boolean columnExists(String table, String column) {
        boolean bl;
        block8: {
            ResultSet rs = this.mysql.query("SHOW COLUMNS FROM `" + table + "` LIKE '" + column + "'", new Object[0]);
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.severe("Failed to check if column exists", e);
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<PlayerData> getPlayerData(UUID uuid) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolvePlayerTable() + " WHERE uuid=?", uuid.toString());){
            if (!crs.next()) {
                Optional<PlayerData> optional2 = Optional.empty();
                return optional2;
            }
            String skinIdentifier = crs.getString("skin_identifier");
            String skinType = crs.getString("skin_type");
            String skinVariant = crs.getString("skin_variant");
            SkinIdentifier identifier = skinIdentifier != null && skinType != null ? SkinIdentifier.of(skinIdentifier, skinVariant == null ? null : SkinVariant.valueOf(skinVariant), SkinType.valueOf(skinType)) : null;
            Optional<PlayerData> optional = Optional.of(PlayerData.of(uuid, identifier));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void setPlayerData(UUID uuid, PlayerData data) {
        boolean hasSkin = data.getSkinIdentifier() != null;
        SkinIdentifier identifier = data.getSkinIdentifier();
        String skinIdentifierString = hasSkin ? identifier.getIdentifier() : null;
        String skinType = hasSkin ? identifier.getSkinType().name() : null;
        String skinVariant = hasSkin && identifier.getSkinVariant() != null ? identifier.getSkinVariant().name() : null;
        this.mysql.execute("INSERT INTO " + this.resolvePlayerTable() + " (uuid, skin_identifier, skin_type, skin_variant) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE skin_identifier=?, skin_type=?, skin_variant=?", uuid.toString(), skinIdentifierString, skinType, skinVariant, skinIdentifierString, skinType, skinVariant);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<PlayerSkinData> getPlayerSkinData(UUID uuid) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolvePlayerSkinTable() + " WHERE uuid=?", uuid.toString());){
            if (!crs.next()) {
                Optional<PlayerSkinData> optional2 = Optional.empty();
                return optional2;
            }
            String lastKnownName = crs.getString("last_known_name");
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            long timestamp = crs.getLong("timestamp");
            Optional<PlayerSkinData> optional = Optional.of(PlayerSkinData.of(uuid, lastKnownName, SkinProperty.of(value, signature), timestamp));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removePlayerSkinData(UUID uuid) {
        this.mysql.execute("DELETE FROM " + this.resolvePlayerSkinTable() + " WHERE uuid=?", uuid.toString());
    }

    @Override
    public void setPlayerSkinData(UUID uuid, PlayerSkinData skinData) {
        this.mysql.execute("INSERT INTO " + this.resolvePlayerSkinTable() + " (uuid, last_known_name, value, signature, timestamp) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE last_known_name=?, value=?, signature=?, timestamp=?", uuid.toString(), skinData.getLastKnownName(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getTimestamp(), skinData.getLastKnownName(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getTimestamp());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<URLSkinData> getURLSkinData(String url, SkinVariant skinVariant) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolveURLSkinTable() + " WHERE url=? AND skin_variant=?", url, skinVariant.name());){
            if (!crs.next()) {
                Optional<URLSkinData> optional2 = Optional.empty();
                return optional2;
            }
            String mineSkinId = crs.getString("mine_skin_id");
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            SkinVariant variant = SkinVariant.valueOf(crs.getString("skin_variant"));
            Optional<URLSkinData> optional = Optional.of(URLSkinData.of(url, mineSkinId, SkinProperty.of(value, signature), variant));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeURLSkinData(String url, SkinVariant skinVariant) {
        this.mysql.execute("DELETE FROM " + this.resolveURLSkinTable() + " WHERE url=? AND skin_variant=?", url, skinVariant.name());
    }

    @Override
    public void setURLSkinData(String url, URLSkinData skinData) {
        this.mysql.execute("INSERT INTO " + this.resolveURLSkinTable() + " (url, mine_skin_id, value, signature, skin_variant) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE mine_skin_id=?, value=?, signature=?, skin_variant=?", url, skinData.getMineSkinId(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getSkinVariant().name(), skinData.getMineSkinId(), skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getSkinVariant().name());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<URLIndexData> getURLSkinIndex(String url) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolveURLSkinIndexTable() + " WHERE url=?", url);){
            if (!crs.next()) {
                Optional<URLIndexData> optional2 = Optional.empty();
                return optional2;
            }
            SkinVariant variant = SkinVariant.valueOf(crs.getString("skin_variant"));
            Optional<URLIndexData> optional = Optional.of(URLIndexData.of(url, variant));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeURLSkinIndex(String url) {
        this.mysql.execute("DELETE FROM " + this.resolveURLSkinIndexTable() + " WHERE url=?", url);
    }

    @Override
    public void setURLSkinIndex(String url, URLIndexData skinData) {
        this.mysql.execute("INSERT INTO " + this.resolveURLSkinIndexTable() + " (url, skin_variant) VALUES (?, ?) ON DUPLICATE KEY UPDATE skin_variant=?", url, skinData.getSkinVariant().name(), skinData.getSkinVariant().name());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<CustomSkinData> getCustomSkinData(String skinName) throws StorageAdapter.StorageException {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolveCustomSkinTable() + " WHERE name=?", skinName);){
            if (!crs.next()) {
                Optional<CustomSkinData> optional2 = Optional.empty();
                return optional2;
            }
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            Optional<CustomSkinData> optional = Optional.of(CustomSkinData.of(skinName, SkinProperty.of(value, signature)));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeCustomSkinData(String skinName) {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        this.mysql.execute("DELETE FROM " + this.resolveCustomSkinTable() + " WHERE name=?", skinName);
    }

    @Override
    public void setCustomSkinData(String skinName, CustomSkinData skinData) {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        this.mysql.execute("INSERT INTO " + this.resolveCustomSkinTable() + " (name, value, signature) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE value=?, signature=?", skinName, skinData.getProperty().getValue(), skinData.getProperty().getSignature(), skinData.getProperty().getValue(), skinData.getProperty().getSignature());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<LegacySkinData> getLegacySkinData(String skinName) throws StorageAdapter.StorageException {
        if (!this.tableExists(this.resolveLegacySkinTable())) return Optional.empty();
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolveLegacySkinTable() + " WHERE name=?", skinName);){
            if (!crs.next()) {
                Optional<LegacySkinData> optional2 = Optional.empty();
                return optional2;
            }
            String value = crs.getString("value");
            String signature = crs.getString("signature");
            Optional<LegacySkinData> optional = Optional.of(LegacySkinData.of(skinName, SkinProperty.of(value, signature)));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeLegacySkinData(String skinName) {
        if (this.tableExists(this.resolveLegacySkinTable())) {
            this.mysql.execute("DELETE FROM " + this.resolveLegacySkinTable() + " WHERE name=?", skinName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<LegacyPlayerData> getLegacyPlayerData(String playerName) throws StorageAdapter.StorageException {
        if (!this.tableExists(this.resolveLegacyPlayerTable())) return Optional.empty();
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolveLegacyPlayerTable() + " WHERE name=?", playerName);){
            if (!crs.next()) {
                Optional<LegacyPlayerData> optional2 = Optional.empty();
                return optional2;
            }
            String skinName = crs.getString("skin_name");
            Optional<LegacyPlayerData> optional = Optional.of(LegacyPlayerData.of(playerName, skinName));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void removeLegacyPlayerData(String playerName) {
        if (this.tableExists(this.resolveLegacyPlayerTable())) {
            this.mysql.execute("DELETE FROM " + this.resolveLegacyPlayerTable() + " WHERE name=?", playerName);
        }
    }

    @Override
    @SuppressFBWarnings(justification="SQL injection is not possible here", value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    public Map<String, String> getStoredGUISkins(int offset) {
        StringBuilder query = new StringBuilder("SELECT * FROM (");
        query.append("SELECT 'player' as type, `last_known_name` as name, `value`, `signature`").append(" FROM ").append(this.resolvePlayerSkinTable());
        if (this.settings.getProperty(GUIConfig.CUSTOM_GUI_ENABLED).booleanValue()) {
            List<String> customSkins;
            query.append(" UNION ALL ");
            query.append("SELECT 'custom' as type, `name`, `value`, `signature`").append(" FROM ").append(this.resolveCustomSkinTable());
            if (this.settings.getProperty(GUIConfig.CUSTOM_GUI_ONLY).booleanValue() && !(customSkins = this.settings.getProperty(GUIConfig.CUSTOM_GUI_SKINS)).isEmpty()) {
                query.append(" WHERE `name` IN (");
                ArrayList<String> sanitizedSkins = new ArrayList<String>();
                for (String customSkin : customSkins) {
                    sanitizedSkins.add("'" + CustomSkinData.sanitizeCustomSkinName(customSkin) + "'");
                }
                query.append(String.join((CharSequence)", ", sanitizedSkins));
                query.append(")");
            }
        }
        query.append(") AS skins LIMIT ").append(offset).append(", ").append(36);
        LinkedHashMap<String, String> skins = new LinkedHashMap<String, String>();
        try (ResultSet crs = this.mysql.query(query.toString(), new Object[0]);){
            while (crs.next()) {
                String name = crs.getString("name");
                String value = crs.getString("value");
                String signature = crs.getString("signature");
                skins.put(name, SkinProperty.of(value, signature).getValue());
            }
        }
        catch (SQLException e) {
            this.logger.warning("Failed to get stored skins", e);
        }
        return skins;
    }

    @Override
    public void purgeStoredOldSkins(long targetPurgeTimestamp) {
        this.mysql.execute("DELETE FROM " + this.resolvePlayerSkinTable() + " WHERE timestamp NOT LIKE 0 AND timestamp<=?", targetPurgeTimestamp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<MojangCacheData> getCachedUUID(String playerName) throws StorageAdapter.StorageException {
        try (ResultSet crs = this.mysql.query("SELECT * FROM " + this.resolveCacheTable() + " WHERE name=?", playerName);){
            if (!crs.next()) {
                Optional<MojangCacheData> optional2 = Optional.empty();
                return optional2;
            }
            String uuidString = crs.getString("uuid");
            UUID uuid = uuidString != null ? UUID.fromString(uuidString) : null;
            long timestamp = crs.getLong("timestamp");
            Optional<MojangCacheData> optional = Optional.of(MojangCacheData.of(uuid, timestamp));
            return optional;
        }
        catch (SQLException e) {
            throw new StorageAdapter.StorageException(e);
        }
    }

    @Override
    public void setCachedUUID(String playerName, MojangCacheData mojangCacheData) {
        String uuid = mojangCacheData.getUniqueId().map(UUID::toString).orElse(null);
        this.mysql.execute("INSERT INTO " + this.resolveCacheTable() + " (name, uuid, timestamp) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE uuid=?, timestamp=?", playerName, uuid, mojangCacheData.getTimestamp(), uuid, mojangCacheData.getTimestamp());
    }

    private String resolveCustomSkinTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "custom_skins";
    }

    private String resolveURLSkinTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "url_skins";
    }

    private String resolveURLSkinIndexTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "url_index";
    }

    private String resolvePlayerSkinTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "player_skins";
    }

    private String resolvePlayerTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "players";
    }

    private String resolveCacheTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "cache";
    }

    private String resolveLegacyPlayerTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "legacy_players";
    }

    private String resolveLegacySkinTable() {
        return this.settings.getProperty(DatabaseConfig.MYSQL_TABLE_PREFIX) + "legacy_skins";
    }

    private Optional<String> getLegacyPlayerTableFile() {
        Path legacyTable = this.getLegacyPlayerTableFilePath();
        try {
            if (Files.exists(legacyTable, new LinkOption[0])) {
                return Optional.of(new String(Files.readAllBytes(legacyTable), StandardCharsets.UTF_8));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getLegacySkinTableFile() {
        Path legacyTable = this.getLegacySkinTableFilePath();
        try {
            if (Files.exists(legacyTable, new LinkOption[0])) {
                return Optional.of(new String(Files.readAllBytes(legacyTable), StandardCharsets.UTF_8));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path getLegacyPlayerTableFilePath() {
        return this.plugin.getDataFolder().resolve("legacy_player_table.txt");
    }

    private Path getLegacySkinTableFilePath() {
        return this.plugin.getDataFolder().resolve("legacy_skin_table.txt");
    }

    @Inject
    public MySQLAdapter(MySQLProvider mysql, SettingsManager settings, SRLogger logger, SRPlugin plugin) {
        this.mysql = mysql;
        this.settings = settings;
        this.logger = logger;
        this.plugin = plugin;
    }
}

